/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.client.screen.VehiclePaintScreen;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.VehicleInputManager;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilSound;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class UtilClientPacket {
    public static void aircraftInputsPacket(int id, VehicleInputManager inputs) {
        EntityVehicle plane;
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle && !(plane = (EntityVehicle)entity).m_6109_()) {
            plane.inputs.updateInputsFromPacket(inputs, plane);
        }
    }

    public static void pingsPacket(int id, List<RadarStats.RadarPing> pings) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            plane.radarSystem.readClientPingsFromServer(pings);
        }
    }

    public static void weaponAmmoPacket(int id, String weaponId, String slotId, int ammo) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            WeaponInstance<?> w = plane.weaponSystem.get(weaponId, slotId);
            if (w != null) {
                w.setCurrentAmmo(ammo);
            }
        }
    }

    public static void weaponSelectPacket(int id, int index) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            plane.weaponSystem.setSelected(index);
        }
    }

    public static void addPartPacket(int id, String slotId, PartInstance<?> data) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null) {
                slot.addPartData(data, plane);
            }
        }
    }

    public static void removePartPacket(int id, String slotId) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null) {
                slot.removePartData(plane);
            }
        }
    }

    public static void syncPartPacket(int id, String slotId, FriendlyByteBuf buffer) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        buffer.m_130277_();
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            PartSlot slot = plane.partsManager.getSlot(slotId);
            if (slot != null && slot.getPartData() != null) {
                slot.getPartData().readBuffer(buffer);
                slot.getPartData().onReceiveClientSync();
            }
        }
    }

    public static void rwrPacket(int id, RadarSystem.RWRWarning warning) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            plane.radarSystem.readRWRWarningFromServer(warning);
        }
    }

    public static void addMomentPacket(int id, Vec3 force, Vec3 moment) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            plane.addForceBetweenTicks = plane.addForceBetweenTicks.m_82549_(force);
            plane.addMomentBetweenTicks = plane.addMomentBetweenTicks.m_82549_(moment);
        }
    }

    public static void vehicleTexturePacket(int ignore_player_id, int vehicle_id, ByteBuf buffer) {
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_.m_19879_() == ignore_player_id) {
            return;
        }
        ClientLevel world = m.f_91073_;
        Entity entity = world.m_6815_(vehicle_id);
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            plane.textureManager.read(buffer);
        }
    }

    public static void openVehicleTextureScreen(VehicleTextureManager textures) {
        Minecraft m = Minecraft.m_91087_();
        m.m_91152_((Screen)new VehiclePaintScreen(textures));
    }

    public static void vehicleExplode(int id, Vec3 pos) {
        Minecraft m = Minecraft.m_91087_();
        if (id == -1) {
            UtilParticles.vehicleCrashExplosion((Level)m.f_91073_, pos, 5.0);
        } else {
            Entity entity = m.f_91073_.m_6815_(id);
            if (entity instanceof EntityVehicle) {
                EntityVehicle plane = (EntityVehicle)entity;
                UtilParticles.vehicleCrashExplosion((Level)m.f_91073_, pos, ((VehicleStats)plane.getStats()).crashExplosionRadius);
            }
        }
    }

    public static void weaponImpact(WeaponStats.WeaponClientImpactType impactType, Vec3 pos) {
        Minecraft m = Minecraft.m_91087_();
        impactType.onClientImpact((Level)m.f_91073_, pos);
    }

    public static void delayedSound(String soundId, Vec3 pos, float range, float volume, float pitch) {
        SoundEvent sound = UtilSound.getSoundByIdClient(soundId, null);
        if (sound == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        float dist = (float)Objects.requireNonNull(m.m_91288_()).m_20182_().m_82554_(pos);
        float attenuationCoefficient = (float)Mth.m_14008_((double)(1.0 / Math.pow((dist + range / 5.0f) / (range * 2.0f), 2.0) / 100.0), (double)0.0, (double)1.0);
        SimpleSoundInstance ssi = new SimpleSoundInstance(sound, SoundSource.PLAYERS, volume * attenuationCoefficient, pitch, RandomSource.m_216335_((long)UtilParticles.random.nextLong()), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        int delay = (int)(dist / DSCPhyCons.getVelSound());
        m.m_91106_().m_120369_((SoundInstance)ssi, delay);
    }

    public static void updateVehicleChain(int vehicleId, int hookId, int playerId, EntityChainHook.ChainUpdateType type) {
        Minecraft m = Minecraft.m_91087_();
        EntityVehicle vehicle = null;
        EntityChainHook hook = null;
        Player player = null;
        if (m.f_91073_ == null) {
            return;
        }
        Entity entity = m.f_91073_.m_6815_(vehicleId);
        if (entity instanceof EntityVehicle) {
            EntityVehicle v;
            vehicle = v = (EntityVehicle)entity;
        }
        if ((entity = m.f_91073_.m_6815_(hookId)) instanceof EntityChainHook) {
            EntityChainHook c;
            hook = c = (EntityChainHook)entity;
        }
        if ((entity = m.f_91073_.m_6815_(playerId)) instanceof Player) {
            Player p;
            player = p = (Player)entity;
        }
        switch (type) {
            case CHAIN_ADD_PLAYER: {
                if (hook == null) {
                    return;
                }
                hook.addPlayerConnection(player);
                return;
            }
            case CHAIN_ADD_VEHICLE: {
                if (hook == null) {
                    return;
                }
                hook.addVehicleConnection(player, vehicle);
                return;
            }
            case CHAIN_DISCONNECT_PLAYER: {
                if (hook == null) {
                    return;
                }
                hook.disconnectPlayer(player);
                return;
            }
            case CHAIN_DISCONNECT_VEHICLE: {
                if (hook == null) {
                    return;
                }
                hook.disconnectVehicle(vehicle);
                return;
            }
            case VEHICLE_ADD_PLAYER: {
                if (vehicle == null) {
                    return;
                }
                vehicle.chainToPlayer(player);
                return;
            }
        }
    }

    public static void debugHitboxPos(int id, String hitbox_name, Vec3 pos, Vec3 size) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        if (world == null) {
            return;
        }
        Entity entity = world.m_6815_(id);
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        RotableHitbox hitbox = vehicle.getHitboxByName(hitbox_name);
        if (hitbox == null) {
            return;
        }
        hitbox.setTestPos(pos);
        hitbox.setTestSize(size);
    }

    public static void onShoot(int vehicleId, int shooterId, ShootType type) {
        Minecraft m = Minecraft.m_91087_();
        ClientLevel world = m.f_91073_;
        if (world == null) {
            return;
        }
        if (type == ShootType.WEAPON_RACK) {
            Entity entity = world.m_6815_(vehicleId);
            if (!(entity instanceof EntityWeaponRack)) {
                return;
            }
            EntityWeaponRack rack = (EntityWeaponRack)entity;
            rack.onClientShoot();
        } else if (type == ShootType.TURRET) {
            Entity entity = world.m_6815_(vehicleId);
            if (!(entity instanceof EntityTurret)) {
                return;
            }
            EntityTurret turret = (EntityTurret)entity;
            turret.onClientShoot();
        } else if (type == ShootType.FLARE) {
            if (m.f_91074_ == null || m.f_91074_.m_20201_().m_19879_() != vehicleId) {
                return;
            }
            Entity entity = world.m_6815_(vehicleId);
            if (!(entity instanceof EntityVehicle)) {
                return;
            }
            EntityVehicle vehicle = (EntityVehicle)entity;
            vehicle.soundManager.playPassengerFlareSound();
        } else if (type == ShootType.CHAFF) {
            if (m.f_91074_ == null || m.f_91074_.m_20201_().m_19879_() != vehicleId) {
                return;
            }
            Entity entity = world.m_6815_(vehicleId);
            if (!(entity instanceof EntityVehicle)) {
                return;
            }
            EntityVehicle vehicle = (EntityVehicle)entity;
            vehicle.soundManager.playPassengerChaffSound();
        }
    }

    public static enum ShootType {
        TURRET,
        WEAPON_RACK,
        FLARE,
        CHAFF;

    }
}

