/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModParticles;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class UtilParticles {
    public static Random random = new Random();

    public static void vehicleCrashExplosion(Level level, Vec3 pos, double expRadius) {
        int i;
        double d;
        expRadius *= 1.8;
        for (d = 1.0; d <= expRadius; d += 1.0) {
            for (i = 0; i < 360; i += 15) {
                level.m_6485_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i) * d, 0.5, Math.sin(i) * d);
            }
        }
        for (d = 1.0; d <= expRadius; d += 1.0) {
            for (i = 0; i < 360; i += 45) {
                level.m_6485_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i), d, Math.sin(i));
            }
        }
        for (d = 1.0; d <= expRadius; d += 1.0) {
            double h = (expRadius - d + 1.0) * 0.075;
            for (int i2 = 0; i2 < 360; i2 += 10) {
                level.m_6485_((ParticleOptions)ModParticles.SHRAPNEL.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i2) * h, d * 0.15, Math.sin(i2) * h);
            }
        }
        for (int i3 = 0; i3 < 32; ++i3) {
            level.m_6485_((ParticleOptions)ModParticles.BIG_FLAME.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.6, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
        }
    }

    public static double randomSpeedUp(double speed, double range) {
        return speed + range * random.nextGaussian();
    }

    public static double randomSpeed(double speed, double range) {
        return speed * (double)UtilParticles.randPosNeg() + range * random.nextGaussian();
    }

    public static int randPosNeg() {
        if (random.nextBoolean()) {
            return 1;
        }
        return -1;
    }

    public static void vehicleParticles(EntityVehicle vehicle) {
        UtilParticles.vehicleAfterBurner(vehicle);
        UtilParticles.fuelLeakSmoke(vehicle);
        UtilParticles.engineFireSmoke(vehicle);
        UtilParticles.vehicleDamageSmoke(vehicle);
    }

    public static void vehicleAfterBurner(EntityVehicle vehicle) {
        QuaternionF q = vehicle.getClientQ();
        Vec3 dir = vehicle.m_20154_().m_82490_((double)(-vehicle.getCurrentThrottle()) * 0.4);
        for (Vec3 relPos : vehicle.getAfterBurnerSmokePos()) {
            Vec3 pos = UtilAngles.rotateVector((Vec3)relPos, (QuaternionF)q).m_82549_(vehicle.m_20182_());
            UtilParticles.afterBurner(vehicle, pos, dir);
        }
    }

    public static void afterBurner(EntityVehicle vehicle, Vec3 pos, Vec3 dir) {
        if (vehicle.showContrailParticles()) {
            vehicle.getWorld().m_7106_((ParticleOptions)ModParticles.CONTRAIL.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, dir.f_82479_, dir.f_82480_, dir.f_82481_);
        }
        if (vehicle.showAfterBurnerParticles()) {
            vehicle.getWorld().m_7106_((ParticleOptions)ModParticles.AFTER_BURNER.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, dir.f_82479_, dir.f_82480_, dir.f_82481_);
            dir = dir.m_82490_(0.5);
            if (vehicle.showMoreAfterBurnerParticles()) {
                vehicle.getWorld().m_7106_((ParticleOptions)ModParticles.AFTER_BURNER.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, dir.f_82479_, dir.f_82480_, dir.f_82481_);
            }
        }
    }

    public static void fuelLeakSmoke(EntityVehicle vehicle) {
        if (!vehicle.isFuelLeak() || vehicle.getCurrentFuel() <= 0.0f) {
            return;
        }
        Vec3 pos = vehicle.m_20182_();
        for (int i = 0; i < 4; ++i) {
            vehicle.getWorld().m_7106_((ParticleOptions)ParticleTypes.f_123782_, pos.f_82479_, pos.f_82480_, pos.f_82481_, random.nextGaussian() * 0.02, -0.1, random.nextGaussian() * 0.02);
        }
    }

    public static void engineFireSmoke(EntityVehicle vehicle) {
        if (!vehicle.isEngineFire()) {
            return;
        }
        for (Vec3 pos : vehicle.getEngineFirePos()) {
            int i;
            for (i = 0; i < 2; ++i) {
                UtilParticles.flame(vehicle.getWorld(), pos);
            }
            for (i = 0; i < 10; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), pos);
            }
            for (i = 0; i < 2; ++i) {
                UtilParticles.bigSmoke(vehicle.getWorld(), pos);
            }
        }
    }

    public static void vehicleDamageSmoke(EntityVehicle vehicle) {
        int i;
        float r = vehicle.getHealth() / vehicle.getMaxHealth();
        if (r < 0.5f) {
            UtilParticles.smoke(vehicle.getWorld(), vehicle.m_20182_());
        }
        if (r < 0.3f) {
            for (i = 0; i < 2; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), vehicle.m_20182_());
            }
            UtilParticles.bigSmoke(vehicle.getWorld(), vehicle.m_20182_());
        }
        if (r < 0.1f) {
            for (i = 0; i < 4; ++i) {
                UtilParticles.smoke(vehicle.getWorld(), vehicle.m_20182_());
            }
            for (i = 0; i < 3; ++i) {
                UtilParticles.bigSmoke(vehicle.getWorld(), vehicle.m_20182_());
            }
        }
    }

    public static void smoke(Level level, Vec3 pos) {
        if (Math.random() > 0.65) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, random.nextGaussian() * 0.01, 0.1, random.nextGaussian() * 0.01);
    }

    public static void bigSmoke(Level level, Vec3 pos) {
        if (Math.random() > 0.4) {
            return;
        }
        level.m_7106_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, random.nextGaussian() * 0.5, random.nextGaussian() * 0.5, random.nextGaussian() * 0.5);
    }

    public static void flame(Level level, Vec3 pos) {
        if (Math.random() > 0.8) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, random.nextGaussian() * 0.005, 0.1, random.nextGaussian() * 0.005);
    }

    public static void missileTrail(Level level, Vec3 pos, Vec3 move, double size, boolean inWater) {
        level.m_7106_((ParticleOptions)ModParticles.CONTRAIL.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, -move.f_82479_ * 0.5, -move.f_82480_ * 0.5, -move.f_82481_ * 0.5);
        level.m_7106_((ParticleOptions)ModParticles.CONTRAIL.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, -move.f_82479_ * 0.25, -move.f_82480_ * 0.25, -move.f_82481_ * 0.25);
    }

    public static void missileAfterBurner(Level level, Vec3 pos, Vec3 dir) {
        level.m_7106_((ParticleOptions)ModParticles.AFTER_BURNER.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, dir.f_82479_, dir.f_82480_, dir.f_82481_);
    }

    public static void bulletImpact(Level level, Vec3 pos, double damage) {
        for (int i = 0; i < 360; i += 30) {
            for (int j = 0; j <= 90; j += 30) {
                level.m_6485_((ParticleOptions)ParticleTypes.f_123755_, true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i) * 0.05, Math.sin(j) * 0.05, Math.sin(i) * 0.05);
            }
        }
    }

    public static void bulletExplode(Level level, Vec3 pos, double radius, boolean fire) {
        radius *= 0.5;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 30) {
                for (int j = -90; j <= 90; j += 30) {
                    level.m_6485_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.m_6485_((ParticleOptions)ModParticles.BIG_FLAME.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }

    public static void bombExplode(Level level, Vec3 pos, double radius, boolean fire) {
        radius *= 0.9;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 20) {
                for (int j = -90; j <= 90; j += 30) {
                    level.m_6485_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.m_6485_((ParticleOptions)ModParticles.BIG_FLAME.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }

    public static void missileExplode(Level level, Vec3 pos, double radius, boolean fire) {
        radius *= 0.8;
        for (double d = 1.0; d <= radius; d += 1.0) {
            for (int i = 0; i < 360; i += 20) {
                for (int j = -90; j <= 90; j += 30) {
                    level.m_6485_((ParticleOptions)ModParticles.LARGE_SMOKE_CLOUD.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, Math.cos(i) * d, Math.sin(j) * d, Math.sin(i) * d);
                }
            }
        }
        if (fire) {
            for (int i = 0; i < 24; ++i) {
                level.m_6485_((ParticleOptions)ModParticles.BIG_FLAME.get(), true, pos.f_82479_, pos.f_82480_ + 0.2, pos.f_82481_, UtilParticles.randomSpeed(0.3, 0.2), UtilParticles.randomSpeedUp(0.45, 0.3), UtilParticles.randomSpeed(0.3, 0.2));
            }
        }
    }
}

