/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.radar.RadarPresets;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.item.ItemPart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UtilPresetParse {
    @Nullable
    public static PartStats getPartStatsFromItem(ItemStack stack) {
        if (stack.m_41782_()) {
            return UtilPresetParse.getPartStatsFromCompound(stack.m_41783_());
        }
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPart)) {
            return null;
        }
        ItemPart part = (ItemPart)item;
        return part.getDefaultPartStats();
    }

    @Nullable
    public static PartStats getPartStatsFromCompound(CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        if (tag.m_128456_()) {
            return null;
        }
        String presetId = "";
        if (tag.m_128441_("part")) {
            presetId = tag.m_128461_("part");
        } else if (tag.m_128441_("presetId")) {
            presetId = tag.m_128461_("presetId");
        } else if (tag.m_128441_("itemid")) {
            presetId = tag.m_128461_("itemid");
            presetId = presetId.split(":")[1];
        }
        if (presetId.isEmpty()) {
            return null;
        }
        return (PartStats)PartPresets.get().get(presetId);
    }

    @Nullable
    public static PartInstance<?> parsePartFromItem(ItemStack stack, String defaultPartPresetId) {
        if (stack.m_41782_()) {
            return UtilPresetParse.parsePartFromCompound(stack.m_41783_());
        }
        PartStats stats = (PartStats)PartPresets.get().get(defaultPartPresetId);
        if (stats == null) {
            return null;
        }
        return stats.createPartInstance();
    }

    @Nullable
    public static PartInstance<?> parsePartFromItem(ItemStack stack) {
        if (stack.m_41782_()) {
            return UtilPresetParse.parsePartFromCompound(stack.m_41783_());
        }
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPart)) {
            return null;
        }
        ItemPart part = (ItemPart)item;
        String presetId = part.getDefaultPartPresetId();
        PartStats stats = (PartStats)PartPresets.get().get(presetId);
        if (stats == null) {
            return null;
        }
        return stats.createPartInstance();
    }

    @Nullable
    public static PartInstance<?> parsePartFromCompound(CompoundTag tag) {
        boolean old;
        PartStats stats = UtilPresetParse.getPartStatsFromCompound(tag);
        if (stats == null) {
            return null;
        }
        if (tag.m_128471_("filled")) {
            return stats.createFilledPartInstance(tag.m_128461_("param"));
        }
        PartInstance<?> data = stats.createPartInstance();
        boolean bl = old = tag.m_128451_("parse_version") < 2;
        if (old || tag.m_128471_("readnbt")) {
            data.readNBT(tag);
        }
        if (tag.m_128441_("param")) {
            data.setParamNotFilled(tag.m_128461_("param"));
        }
        return data;
    }

    @Nullable
    public static WeaponInstance<?> parseWeaponFromCompound(CompoundTag tag) {
        return (WeaponInstance)WeaponPresets.get().createInstanceFromNbt(tag);
    }

    @Nullable
    public static RadarStats parseRadarFromCompound(CompoundTag tag) {
        return RadarPresets.get().getFromNbt(tag);
    }
}

