/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.onewhohears.dscombat.client.entityscreen.instance.RadarScreenInstance;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilRender;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class BigRadarScreenInstance
extends RadarScreenInstance {
    public static final class_2960 TEXTURE = new class_2960("dscombat", "textures/ui/entity_screen/big_radar_screen_bg.png");

    public BigRadarScreenInstance(int id) {
        super("big_radar", id, TEXTURE, 512, 512, 256, 256, 240, 20);
    }

    @Override
    public void draw(class_1297 entity, class_4587 poseStack, class_4597 buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        super.draw(entity, poseStack, buffer, partialTicks, packedLight, worldWidth, worldHeight);
        int range = (int)DSCClientInputs.getRadarDisplayRange();
        String format_range = String.format("DR: %4d", range);
        UtilRender.drawText((class_2561)UtilMCText.literal((String)format_range), -0.48f, -0.48f, 0.25f, poseStack, buffer, 65280, packedLight);
    }

    @Override
    protected void updateTexture(class_1297 entity) {
        this.clearDynamicPixels();
        int x2 = (int)((double)this.centerX + (double)this.textureRadius * Math.cos(Math.toRadians(-entity.field_6012 * 4)));
        int y2 = (int)((double)this.centerY + (double)this.textureRadius * Math.sin(Math.toRadians(-entity.field_6012 * 4)));
        this.drawLine(this.centerX, this.centerY, x2, y2, 9, -16711936);
        EntityVehicle vehicle = (EntityVehicle)entity;
        List<RadarStats.RadarPing> pings = vehicle.radarSystem.getClientRadarPings();
        int selected = vehicle.radarSystem.getClientSelectedPingIndex();
        int hover = DSCClientInputs.getRadarHoverIndex();
        for (int i = 0; i < pings.size(); ++i) {
            if (i == selected || i == hover) continue;
            RadarStats.RadarPing ping = pings.get(i);
            this.drawPing(ping, vehicle, false, false);
        }
        if (hover > -1 && hover < pings.size()) {
            this.drawPing(pings.get(hover), vehicle, false, true);
        }
        if (selected > -1 && selected < pings.size()) {
            this.drawPing(pings.get(selected), vehicle, true, false);
        }
    }
}

