/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.onewhohears.dscombat.client.entityscreen.instance.EntityDynamicScreenInstance;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class RWRScreenInstance
extends EntityDynamicScreenInstance {
    public static final class_2960 TEXTURE = new class_2960("dscombat", "textures/ui/entity_screen/rwr_screen_bg.png");
    protected static double OUTLINE_DISTANCE = 5000.0;
    protected static double OUTLINE_DISTANCE_INV = 1.0 / OUTLINE_DISTANCE;
    protected static double TINY_DISTANCE = 10000.0;
    public static final double SMALLEST_SIZE = 0.5;
    protected final int centerX;
    protected final int centerY;
    protected final int textureRadius;

    public RWRScreenInstance(int id) {
        super("rwr", id, TEXTURE, 512, 512);
        this.textureRadius = 248;
        this.centerX = this.pixelWidth / 2;
        this.centerY = this.pixelHeight / 2;
    }

    @Override
    public boolean shouldUpdateTexture(class_1297 entity) {
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (entity.field_6012 == this.prevUpdateTickCount) {
            return false;
        }
        if (entity.field_6012 % 2 != 0) {
            return false;
        }
        return entity.field_6012 - vehicle.radarSystem.clientRwrRefreshTime <= 100;
    }

    @Override
    protected void updateTexture(class_1297 entity) {
        this.clearDynamicPixels();
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (!vehicle.radarSystem.clientHasRWRWarnings()) {
            return;
        }
        Collection<RadarSystem.RWRWarning> warnings = vehicle.radarSystem.getClientRWRWarnings();
        this.updateConstants();
        for (RadarSystem.RWRWarning warn : warnings) {
            this.drawWarning(warn, vehicle);
        }
    }

    protected void updateConstants() {
        OUTLINE_DISTANCE = DSCPhyCons.getIRLScale() * 40000.0;
        OUTLINE_DISTANCE_INV = 1.0 / OUTLINE_DISTANCE;
        TINY_DISTANCE = OUTLINE_DISTANCE * 2.0;
    }

    protected void drawWarning(RadarSystem.RWRWarning warn, EntityVehicle vehicle) {
        class_243 dp = warn.pos.method_1020(vehicle.method_19538());
        double dist = dp.method_37267();
        double screen_dist = dist * OUTLINE_DISTANCE_INV;
        double size = 1.0;
        if (screen_dist > 1.0) {
            if (dist > TINY_DISTANCE) {
                size = 0.5;
            } else {
                double dist_scale = 1.0 - (dist - OUTLINE_DISTANCE) / (TINY_DISTANCE - OUTLINE_DISTANCE);
                size = dist_scale * 0.5 + 0.5;
            }
            screen_dist = 1.0;
        } else if (screen_dist < 0.03) {
            screen_dist = 0.03;
        }
        float yaw = (UtilAngles.getYaw((class_243)dp) - vehicle.method_36454() + 180.0f) * ((float)Math.PI / 180);
        int x = Math.min(this.centerX + (int)((double)(-class_3532.method_15374((float)yaw) * (float)this.textureRadius) * screen_dist), this.pixelWidth - 1);
        int y = Math.min(this.centerY + (int)((double)(class_3532.method_15362((float)yaw) * (float)this.textureRadius) * screen_dist), this.pixelHeight - 1);
        this.drawWarningAtPos(warn, x, y, size);
    }

    protected void drawWarningAtPos(RadarSystem.RWRWarning warn, int x, int y, double size) {
        int r = (int)(32.0 * size);
        int t = (int)(5.0 * size);
        if (warn.isMissile) {
            this.drawDiamond(x, y, r, t, -16776961);
            this.drawCross(x, y, r / 2, t, -16776961);
        } else if (warn.fromGround) {
            this.drawDiamond(x, y, r, t, -16711681);
            this.drawPlus(x, y, r, t, -16711681);
        } else {
            this.drawDiamond(x, y, r, t, -16711936);
        }
    }
}

