/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.Map;

public class BroncoPlaneModel
extends ObjVehicleModel<EntityVehicle> {
    private static final Vec3f PIVOT = new Vec3f(0.0f, -2.0f, 2.0f);

    public BroncoPlaneModel() {
        super("bronco-plane");
    }

    protected void addComponentTransforms(Map<String, Mat4f> transforms, EntityVehicle entity, float partialTicks) {
        Mat4f right_flap;
        Mat4f left_flap;
        Mat4f lg0_mat;
        Mat4f lg1_mat;
        Mat4f lg2_mat;
        float bladerot = entity.getMotorRotation(partialTicks, 30.0f);
        float gearpos = entity.getLandingGearPos(partialTicks);
        Mat4f blade0rot_mat = UtilAngles.pivotPixelsRotZ((float)44.8001f, (float)32.256f, (float)11.0114f, (float)bladerot);
        Mat4f blade1rot_mat = UtilAngles.pivotPixelsRotZ((float)-44.8001f, (float)32.256f, (float)11.0114f, (float)bladerot);
        if (gearpos >= 1.0f) {
            lg1_mat = lg2_mat = INVISIBLE;
            lg0_mat = lg2_mat;
        } else {
            float degrees = gearpos * 90.0f;
            lg0_mat = UtilAngles.pivotPixelsRotX((float)-0.5f, (float)18.0f, (float)50.5f, (float)degrees);
            lg1_mat = UtilAngles.pivotPixelsRotX((float)41.5f, (float)24.0f, (float)-24.5f, (float)degrees);
            lg2_mat = UtilAngles.pivotPixelsRotX((float)-42.5f, (float)24.0f, (float)-24.5f, (float)degrees);
        }
        QuaternionF rudderRot = Vec3f.YP.rotationDegrees(entity.inputs.yaw * 15.0f);
        rudderRot.mul(Vec3f.ZP.rotationDegrees(entity.inputs.yaw * -10.0f));
        Mat4f left_rudder = UtilAngles.pivotPixelsRot((float)44.7787f, (float)52.3335f, (float)-127.6889f, (QuaternionF)rudderRot);
        Mat4f right_rudder = UtilAngles.pivotPixelsRot((float)-44.7787f, (float)52.3335f, (float)-127.6889f, (QuaternionF)rudderRot);
        Mat4f elevator = UtilAngles.pivotPixelsRotX((float)0.0f, (float)73.6614f, (float)-140.7049f, (float)(entity.inputs.pitch * 22.0f));
        if (entity.isFlapsDown()) {
            left_flap = UtilAngles.pivotPixelsRotX((float)98.9282f, (float)43.4165f, (float)-34.7215f, (float)-22.0f);
            right_flap = UtilAngles.pivotPixelsRotX((float)-98.9282f, (float)43.4165f, (float)-34.7215f, (float)-22.0f);
        } else {
            left_flap = UtilAngles.pivotPixelsRotX((float)98.9282f, (float)43.4165f, (float)-34.7215f, (float)(entity.inputs.roll * -22.0f));
            right_flap = UtilAngles.pivotPixelsRotX((float)-98.9282f, (float)43.4165f, (float)-34.7215f, (float)(entity.inputs.roll * 22.0f));
        }
        QuaternionF stickRot = Vec3f.XP.rotationDegrees(entity.inputs.pitch * -25.0f);
        stickRot.mul(Vec3f.ZP.rotationDegrees(entity.inputs.roll * 25.0f));
        Mat4f stick = UtilAngles.pivotPixelsRot((float)0.0f, (float)26.1123f, (float)47.0f, (QuaternionF)stickRot);
        Mat4f left_pedal = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * -0.0625f));
        Mat4f right_pedal = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * 0.0625f));
        Mat4f throttle = Mat4f.createTranslateMatrix((float)0.0f, (float)0.0f, (float)(entity.getCurrentThrottle() * 0.125f));
        transforms.put("blade0", blade0rot_mat);
        transforms.put("blade1", blade1rot_mat);
        transforms.put("lg0", lg0_mat);
        transforms.put("lg1", lg1_mat);
        transforms.put("lg2", lg2_mat);
        transforms.put("surface0", left_flap);
        transforms.put("surface1", right_flap);
        transforms.put("surface2", left_rudder);
        transforms.put("surface3", right_rudder);
        transforms.put("surface4", elevator);
        transforms.put("stick", stick);
        transforms.put("pedal0", left_pedal);
        transforms.put("pedal1", right_pedal);
        transforms.put("throttle", throttle);
    }

    public Vec3f getGlobalPivot() {
        return PIVOT;
    }
}

