/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class HeliStatusOverlay
extends VehicleOverlayComponent {
    private static final int TEXT_COLOR = new Color(65280).getRGB();
    private static final int WARN_COLOR = new Color(0xFFAA00).getRGB();
    private static final int DANGER_COLOR = new Color(0xFF3333).getRGB();
    private static final int OFF_COLOR = new Color(0x888888).getRGB();

    @Override
    protected boolean shouldRender(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        if (HeliStatusOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return HeliStatusOverlay.getPlayerRootVehicle() instanceof EntityHelicopter;
    }

    @Override
    protected void render(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityHelicopter heli = (EntityHelicopter)HeliStatusOverlay.getPlayerRootVehicle();
        assert (heli != null);
        int x = 6;
        int y = screenHeight - 70;
        double rpm = Math.max(0.0, Math.min(1.0, heli.getRotorPower())) * 100.0;
        graphics.method_25303(FONT, String.format("RPM: %3.0f%%", rpm), x, y, TEXT_COLOR);
        y += 10;
        double hMax = (Double)Config.SERVER.groundEffectMaxHeight.get();
        boolean ige = false;
        if (((Boolean)Config.SERVER.enableGroundEffect.get()).booleanValue() && hMax > 0.0) {
            int limit = (int)Math.ceil(hMax) + 1;
            int aglBlocks = UtilVehicleEntity.getDistFromGround((class_1297)heli, limit, true);
            ige = (double)aglBlocks < hMax;
        }
        graphics.method_25303(FONT, "IGE: " + (ige ? "ON" : "OFF"), x, y, ige ? TEXT_COLOR : OFF_COLOR);
        double speedXZ = heli.method_18798().method_37267();
        double etlFull = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
        double etlFactor = Math.min(1.0, speedXZ / etlFull);
        boolean etl = (Boolean)Config.SERVER.enableTranslationalLift.get() != false && etlFactor > 0.05;
        graphics.method_25303(FONT, "ETL: " + (etl ? String.format("%d%%", (int)(etlFactor * 100.0)) : "OFF"), x, y += 10, etl ? WARN_COLOR : OFF_COLOR);
        y += 10;
        double vy = heli.method_18798().field_1351;
        double descent = vy < 0.0 ? -vy : 0.0;
        double vrsTrig = (Double)Config.SERVER.vrsDescentTrigger.get();
        double vrsMaxSpeed = (Double)Config.SERVER.vrsHorizMaxSpeed.get();
        boolean vrs = (Boolean)Config.SERVER.enableVRS.get() != false && descent > vrsTrig && speedXZ < vrsMaxSpeed;
        graphics.method_25303(FONT, "VRS: " + (vrs ? "ENGAGED" : "OK"), x, y, vrs ? DANGER_COLOR : TEXT_COLOR);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_heli_status";
    }
}

