/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class PosRangeOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        if (DSCClientInputs.getTargetMode() == DSCClientInputs.TargetMode.LOOK) {
            return false;
        }
        if (PosRangeOverlay.defaultRenderConditions()) {
            return false;
        }
        class_1297 class_12972 = PosRangeOverlay.getPlayerRootVehicle();
        if (!(class_12972 instanceof EntityVehicle)) {
            return false;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (data == null) {
            return false;
        }
        return ((WeaponStats)data.getStats()).isPosGuided();
    }

    @Override
    protected void render(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        int color;
        class_1297 class_12972 = PosRangeOverlay.getPlayerRootVehicle();
        if (!(class_12972 instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)class_12972;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        assert (data != null);
        double range = ((WeaponStats)data.getStats()).getMobTurretRange();
        class_243 pos = Config.CLIENT.getTargetPos();
        int dist = (int)pos.method_1022(vehicle.method_19538());
        int alt = UtilEntity.getDistFromSeaLevel((double)pos.field_1351, (class_1937)vehicle.getWorld());
        String text = dist + " | " + alt;
        if ((double)dist <= range) {
            color = 65280;
            text = text + " | O";
        } else {
            color = 0xFF0000;
            text = text + " | X";
        }
        graphics.method_25300(FONT, text, screenWidth / 2, screenHeight / 2 - 20, color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_pos_range";
    }
}

