/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class VehicleThrottleOverlay
extends VehicleOverlayComponent {
    public static final class_2960 THROTTLE_RAIL = new class_2960("dscombat", "textures/ui/throttle_rail.png");
    public static final class_2960 THROTTLE_HANDLE = new class_2960("dscombat", "textures/ui/throttle_handle.png");
    public static final int THROTTLE_RAIL_LENGTH = 70;
    public static final int THROTTLE_WIDTH = 10;
    public static final int THROTTLE_KNOB_HEIGHT = 10;

    @Override
    protected boolean shouldRender(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleThrottleOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleThrottleOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(class_329 gui, class_332 graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleThrottleOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1 - 10 - 1;
        int yOrigin = screenHeight - 70 - 1;
        RenderSystem.setShaderTexture((int)0, (class_2960)THROTTLE_RAIL);
        graphics.method_25290(THROTTLE_RAIL, xOrigin, yOrigin, 0.0f, 0.0f, 10, 70, 10, 70);
        RenderSystem.setShaderTexture((int)0, (class_2960)THROTTLE_HANDLE);
        int throttleYPos = yOrigin + 70 - 10;
        int throttleLength = 60;
        float throttle = vehicle.inputs.getGoalThrottle(vehicle);
        throttleYPos = ((VehicleStats)vehicle.getStats()).negativeThrottle ? throttleYPos - throttleLength / 2 - (int)(throttle * (float)throttleLength / 2.0f) : (throttleYPos -= (int)(throttle * (float)throttleLength));
        graphics.method_25290(THROTTLE_HANDLE, xOrigin, throttleYPos, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_throttle";
    }
}

