/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class VehicleReloadScreen
extends VehicleSubScreen {
    public static final class_2960 BG_TEXTURE = new class_2960("dscombat", "textures/ui/background/vehicle_reload_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private static final class_2583 style = class_2583.field_24360.method_36139(34816);

    protected VehicleReloadScreen() {
        super("screen.dscombat.vehicle_reload_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    @Override
    protected void method_25426() {
        int xStart;
        this.COLUMNS = 3;
        this.vertical_widget_shift = 10;
        super.method_25426();
        this.positionWidgetGrid((class_339)new class_4185(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.reload_all"), onPress -> this.onReloadAllButton(), Supplier::get), this.ROWS, this.COLUMNS, 1, 2);
        this.positionWidgetGrid((class_339)new class_4185(0, 0, 20, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.unload_all"), onPress -> this.onUnloadAllButton(), Supplier::get), this.ROWS, this.COLUMNS, 2, 2);
        this.vertical_widget_shift = 34;
        float scale = 0.6666667f;
        int textHeight = (int)(20.0f * scale);
        int x = xStart = this.guiX + this.left_padding;
        int y = this.guiY + this.top_padding + this.vertical_widget_shift;
        int width = (this.image_width - this.left_padding - this.right_padding) / 3;
        List<PartSlot> slots = this.getVehicle().partsManager.getReloadableParts();
        int halfWidth = width / 2;
        for (int i = 0; i < slots.size(); ++i) {
            PartSlot slot = slots.get(i);
            ReloadablePartInstance part = (ReloadablePartInstance)((Object)slot.getPartData());
            if (part == null) continue;
            class_4185 reload = new class_4185(0, 0, halfWidth, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.reload"), onPress -> this.onReloadButton(slot.getSlotId()), Supplier::get);
            reload.method_46421(x);
            reload.method_46419(y + textHeight);
            this.method_37063((class_364)reload);
            class_4185 unload = new class_4185(0, 0, halfWidth, 20, (class_2561)UtilMCText.translatable((String)"ui.dscombat.unload"), onPress -> this.onUnloadButton(slot.getSlotId()), Supplier::get);
            unload.method_46421(x + halfWidth);
            unload.method_46419(y + textHeight);
            this.method_37063((class_364)unload);
            if (i % 3 == 2) {
                y += textHeight + 20;
                x = xStart;
                continue;
            }
            x += width;
        }
    }

    @Override
    public void method_25420(@NotNull class_332 graphics) {
        int xStart;
        super.method_25420(graphics);
        graphics.method_51448().method_22903();
        float scale = 0.6666667f;
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        int x = xStart = (int)((float)(this.guiX + this.left_padding) / scale);
        int y = (int)((float)(this.guiY + this.top_padding + this.vertical_widget_shift) / scale);
        int width = (int)((float)(this.image_width - this.left_padding - this.right_padding) / 3.0f / scale);
        List<PartSlot> slots = this.getVehicle().partsManager.getReloadableParts();
        for (int i = 0; i < slots.size(); ++i) {
            ReloadablePartInstance part = (ReloadablePartInstance)((Object)slots.get(i).getPartData());
            if (part == null) continue;
            graphics.method_27535(this.field_22793, (class_2561)part.getItemName().method_10862(style), x, y, 0xFFFFFF);
            class_5250 ammo = UtilMCText.translatable((String)"info.dscombat.ammo").method_27693(": " + (int)part.getCurrentAmmo() + "/" + (int)part.getMaxAmmo());
            graphics.method_27535(this.field_22793, (class_2561)ammo.method_10862(style), x, y + 10, 0xFFFFFF);
            if (i % 3 == 2) {
                y += 50;
                x = xStart;
                continue;
            }
            x += width;
        }
        graphics.method_51448().method_22909();
    }

    private void onReloadAllButton() {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(false));
    }

    private void onUnloadAllButton() {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(true));
    }

    private void onReloadButton(String slotId) {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(slotId, false));
    }

    private void onUnloadButton(String slotId) {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(slotId, true));
    }
}

