/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.onewhohears.dscombat.command.argument.WeaponArgument;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5473;

public class MissileCommand {
    public MissileCommand(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"missile").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"no_owner").then(this.testMissileParams(ctx -> null)))).then(class_2170.method_9244((String)"owner", (ArgumentType)class_2186.method_9309()).then(this.testMissileParams(ctx -> class_2186.method_9313((CommandContext)ctx, (String)"owner")))));
    }

    private ArgumentBuilder<class_2168, ?> testMissileParams(GetOwnerCommand owner) {
        return class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> this.testMissile((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"target"), class_2277.method_9736((CommandContext)context, (String)"pos"), null, owner.apply((CommandContext<class_2168>)context), -1.0, -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"weapon", (ArgumentType)WeaponArgument.weapon()).executes(context -> this.testMissile((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"target"), class_2277.method_9736((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<class_2168>)context, "weapon"), owner.apply((CommandContext<class_2168>)context), -1.0, -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"speed", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(context -> this.testMissile((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"target"), class_2277.method_9736((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<class_2168>)context, "weapon"), owner.apply((CommandContext<class_2168>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pitch", (ArgumentType)class_5473.method_30658()).executes(context -> this.testMissile((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"target"), class_2277.method_9736((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<class_2168>)context, "weapon"), owner.apply((CommandContext<class_2168>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), class_5473.method_30660((CommandContext)context, (String)"pitch"), -1000.0f))).then(class_2170.method_9244((String)"yaw", (ArgumentType)class_5473.method_30658()).executes(context -> this.testMissile((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"target"), class_2277.method_9736((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<class_2168>)context, "weapon"), owner.apply((CommandContext<class_2168>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), class_5473.method_30660((CommandContext)context, (String)"pitch"), class_5473.method_30660((CommandContext)context, (String)"yaw"))))))));
    }

    private int testMissile(CommandContext<class_2168> context, Collection<? extends class_1297> targets, class_243 pos, WeaponStats weaponStats, class_1297 owner, double initSpeed, float pitch, float yaw) throws CommandSyntaxException {
        String defaultId = "aim120b";
        if (weaponStats == null) {
            weaponStats = WeaponPresets.get().get(defaultId);
        }
        if (weaponStats == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)UtilMCText.translatable((String)"error.dscombat.default_weapon_not_exist", (Object[])new Object[]{defaultId}));
            return 0;
        }
        WeaponInstance<?> weapon = weaponStats.createWeaponInstance();
        int i = 0;
        for (class_1297 class_12972 : targets) {
            class_1937 level;
            EntityWeapon<?> ew;
            class_243 dp = class_12972.method_19538().method_1020(pos).method_1029();
            if (pitch != -1000.0f) {
                if (yaw == -1000.0f) {
                    yaw = UtilAngles.getYaw((class_243)dp);
                }
                dp = class_243.method_1030((float)pitch, (float)yaw);
            }
            if ((ew = weapon.getEntity(level = UtilEntity.getLevel((class_1297)class_12972))) == null) continue;
            ew.method_7432(owner);
            ew.method_33574(pos);
            weapon.setDirection(ew, dp);
            if (initSpeed != -1.0) {
                ew.method_18799(dp.method_1021(initSpeed));
            }
            if (ew instanceof EntityMissile) {
                class_1297 v;
                EntityMissile missile = (EntityMissile)ew;
                missile.target = v = class_12972.method_5668();
                missile.targetPos = v.method_19538();
            }
            level.method_8649(ew);
            ++i;
        }
        if (i == 0) {
            ((class_2168)context.getSource()).method_9213((class_2561)UtilMCText.translatable((String)"error.dscombat.no_targets_found"));
        } else if (i > 0) {
            int num = i;
            ((class_2168)context.getSource()).method_9226(() -> UtilMCText.translatable((String)"success.dscombat.launched_missile", (Object[])new Object[]{num}), true);
        }
        return 1;
    }

    static interface GetOwnerCommand {
        public class_1297 apply(CommandContext<class_2168> var1) throws CommandSyntaxException;
    }
}

