/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.graph;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_2960;

public abstract class Graph<K extends Number, V extends Number>
extends JsonPresetStats {
    private final int size;
    private final boolean mirror_negative_keys;
    private final boolean invert_mirrored_values;

    public Graph(class_2960 key, JsonObject json) {
        super(key, json);
        this.size = UtilParse.getIntSafe((JsonObject)json, (String)"size", (int)0);
        this.mirror_negative_keys = UtilParse.getBooleanSafe((JsonObject)json, (String)"mirror_negative_keys", (boolean)false);
        this.invert_mirrored_values = UtilParse.getBooleanSafe((JsonObject)json, (String)"invert_mirrored_values", (boolean)false);
    }

    public int getSize() {
        return this.size;
    }

    public abstract K[] getKeys();

    public abstract V[] getValues();

    public abstract boolean isFloatLessThan(float var1, K var2);

    public int getFloorIndex(float key) {
        if (this.isFloatLessThan(key, this.getKeys()[0])) {
            return 0;
        }
        for (int i = 0; i < this.getSize() - 1; ++i) {
            if (!this.isFloatLessThan(key, this.getKeys()[i + 1])) continue;
            return i;
        }
        return this.getSize() - 1;
    }

    public int getCeilIndex(float key) {
        if (this.isFloatLessThan(key, this.getKeys()[0])) {
            return 0;
        }
        for (int i = 0; i < this.getSize() - 1; ++i) {
            if (!this.isFloatLessThan(key, this.getKeys()[i + 1])) continue;
            return i + 1;
        }
        return this.getSize() - 1;
    }

    public V getFloor(float key) {
        return (V)this.getFloor(key, this.getValues());
    }

    public V getCeil(float key) {
        return (V)this.getCeil(key, this.getValues());
    }

    protected V getFloor(float key, V[] values) {
        return values[this.getFloorIndex(key)];
    }

    protected V getCeil(float key, V[] values) {
        return values[this.getCeilIndex(key)];
    }

    protected float getLerpFloat(float key, V[] values) {
        boolean mirroredKey = false;
        if (this.isMirrorNegativeKeys() && key < 0.0f) {
            key *= -1.0f;
            mirroredKey = true;
        }
        int floorI = this.getFloorIndex(key);
        int ceilI = this.getCeilIndex(key);
        float floorValue = ((Number)values[floorI]).floatValue();
        if (floorI == ceilI) {
            return floorValue;
        }
        float floorKey = this.getKeys()[floorI].floatValue();
        float ceilKey = this.getKeys()[ceilI].floatValue();
        float ceilValue = ((Number)values[ceilI]).floatValue();
        if (mirroredKey) {
            key *= -1.0f;
            float tempKey = floorKey;
            floorKey = -ceilKey;
            ceilKey = -tempKey;
            float tempValue = floorValue;
            floorValue = ceilValue;
            ceilValue = tempValue;
            if (this.isInvertMirroredValues()) {
                floorValue *= -1.0f;
                ceilValue *= -1.0f;
            }
        }
        float d = key - floorKey;
        return d * (ceilValue - floorValue) / (ceilKey - floorKey) + floorValue;
    }

    public float getLerpFloat(float key) {
        return this.getLerpFloat(key, this.getValues());
    }

    public boolean isMirrorNegativeKeys() {
        return this.mirror_negative_keys;
    }

    public boolean isInvertMirroredValues() {
        return this.invert_mirrored_values;
    }
}

