/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientAddPart;
import com.onewhohears.dscombat.common.network.toclient.ToClientRemovePart;
import com.onewhohears.dscombat.common.network.toclient.ToClientSyncPart;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class PartSlot {
    public static final String PILOT_SLOT_NAME = "pilot_seat";
    public static final String COPILOT_SLOT_NAME = "copilot_seat";
    private final String slotId;
    private final SlotType type;
    private final class_243 pos;
    private final float zRot;
    private final boolean locked;
    private final String onlyCompatPart;
    private final String linkedHitbox;
    private PartInstance<?> data;

    public PartSlot(class_2487 entityNbt, @Nullable class_2487 presetNbt) {
        this.slotId = entityNbt.method_10558("name");
        this.locked = entityNbt.method_10577("locked");
        if (entityNbt.method_10545("data")) {
            this.data = UtilPresetParse.parsePartFromCompound(entityNbt.method_10562("data"));
        }
        if (presetNbt == null) {
            presetNbt = entityNbt;
        }
        this.type = SlotType.getByName(presetNbt.method_10558("slot_type"));
        this.pos = UtilParse.readVec3((class_2487)presetNbt, (String)"slot_pos");
        this.zRot = presetNbt.method_10583("zRot");
        this.onlyCompatPart = presetNbt.method_10558("onlyCompatPart");
        this.linkedHitbox = presetNbt.method_10558("linkedHitbox");
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10582("name", this.slotId);
        tag.method_10582("slot_type", this.type.getSlotTypeName());
        UtilParse.writeVec3((class_2487)tag, (class_243)this.pos, (String)"slot_pos");
        tag.method_10548("zRot", this.zRot);
        tag.method_10556("locked", this.locked);
        tag.method_10582("onlyCompatPart", this.onlyCompatPart);
        tag.method_10582("linkedHitbox", this.linkedHitbox);
        if (this.filled()) {
            tag.method_10566("data", (class_2520)this.data.writeNBT());
        }
        return tag;
    }

    public PartSlot(class_2540 buffer) {
        this.slotId = buffer.method_19772();
        this.type = SlotType.getByName(buffer.method_19772());
        this.pos = (class_243)DataSerializers.VEC3.method_12716(buffer);
        this.zRot = buffer.readFloat();
        this.locked = buffer.readBoolean();
        this.onlyCompatPart = buffer.method_19772();
        this.linkedHitbox = buffer.method_19772();
        boolean notNull = buffer.readBoolean();
        if (notNull) {
            this.data = (PartInstance)((Object)DataSerializers.PART_DATA.method_12716(buffer));
        }
    }

    public void write(class_2540 buffer) {
        buffer.method_10814(this.slotId);
        buffer.method_10814(this.type.getSlotTypeName());
        DataSerializers.VEC3.method_12715(buffer, (Object)this.pos);
        buffer.writeFloat(this.zRot);
        buffer.writeBoolean(this.locked);
        buffer.method_10814(this.onlyCompatPart);
        buffer.method_10814(this.linkedHitbox);
        buffer.writeBoolean(this.filled());
        if (this.filled()) {
            DataSerializers.PART_DATA.method_12715(buffer, this.data);
        }
    }

    public class_243 getRelPos() {
        return this.pos;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public final boolean filled() {
        return this.data != null;
    }

    @Nullable
    public PartInstance<?> getPartData() {
        return this.data;
    }

    public void serverSetup(EntityVehicle plane) {
        if (this.filled() && this.data.canSetup()) {
            this.data.setup(plane, this.slotId, this.pos);
        }
    }

    public void clientSetup(EntityVehicle plane) {
        if (this.filled() && this.data.canSetup()) {
            this.data.setup(plane, this.slotId, this.pos);
        }
    }

    protected void serverTick() {
        if (this.filled()) {
            this.data.tick(this.slotId);
        }
    }

    protected void clientTick() {
        if (this.filled()) {
            this.data.clientTick(this.slotId);
        }
    }

    public boolean dropPartItem(EntityVehicle parent) {
        if (parent.isClientSide()) {
            return false;
        }
        if (!this.filled()) {
            return false;
        }
        UtilEntity.dropItemStack((class_1937)parent.getWorld(), (class_1799)this.getPartData().getNewItemStack(), (class_243)parent.convertRelPos(this.getRelPos()));
        return this.removePartData(parent);
    }

    public boolean addPartData(PartInstance<?> data, EntityVehicle plane) {
        if (this.filled()) {
            return false;
        }
        if (!this.isCompatible(data)) {
            return false;
        }
        this.data = data;
        if (plane == null) {
            return true;
        }
        if (data.canSetup()) {
            data.setup(plane, this.slotId, this.pos);
        }
        if (!plane.isClientSide()) {
            PacketHandler.sendToTrackers(new ToClientAddPart(plane.method_5628(), this.slotId, data), (class_1297)plane);
        }
        return true;
    }

    public boolean removePartData(EntityVehicle plane) {
        if (!this.filled()) {
            return false;
        }
        this.data.remove(plane, this.slotId);
        if (!plane.isClientSide()) {
            PacketHandler.sendToTrackers(new ToClientRemovePart(plane.method_5628(), this.slotId), (class_1297)plane);
        }
        this.data = null;
        return true;
    }

    public boolean setPartDamaged(EntityVehicle vehicle) {
        if (!this.filled()) {
            return false;
        }
        if (this.data.isDamaged()) {
            return true;
        }
        this.data.onDamaged(vehicle, this.slotId);
        return true;
    }

    public boolean canGetDamaged() {
        return this.filled() && !this.isNormalSeat() && !this.getPartData().isDamaged();
    }

    public boolean setPartRepaired(EntityVehicle vehicle) {
        if (!this.filled()) {
            return false;
        }
        if (!this.data.isDamaged()) {
            return true;
        }
        this.data.onRepaired(vehicle, this.slotId, this.pos);
        return true;
    }

    public void checkDirtyToSync(EntityVehicle vehicle) {
        if (this.getPartData() == null) {
            return;
        }
        if (!vehicle.getWorld().method_8608() && this.data.isDirty()) {
            PacketHandler.sendToTrackers(new ToClientSyncPart(vehicle, this.getPartData()), (class_1297)vehicle);
            this.getPartData().onSendClientSync();
        }
    }

    public boolean isSeat() {
        if (this.data != null) {
            return ((PartStats)this.data.getStats()).isSeat();
        }
        return false;
    }

    public boolean isNormalSeat() {
        if (this.data != null) {
            return ((PartStats)this.data.getStats()).getType().is((JsonPresetType)PartType.SEAT);
        }
        return false;
    }

    public boolean isOnlyCompatWithOnePart() {
        return !this.onlyCompatPart.isEmpty();
    }

    public String getOnlyCompatPartId() {
        return this.onlyCompatPart;
    }

    public boolean isCompatible(PartInstance<?> data) {
        if (data == null) {
            return false;
        }
        if (this.isOnlyCompatWithOnePart()) {
            return data.getStatsId().equals(this.getOnlyCompatPartId());
        }
        return data.isCompatible(this.getSlotType());
    }

    public static String getSlotId(String slotId) {
        if (slotId.startsWith("slotname.dscombat.")) {
            return slotId.substring("slotname.dscombat.".length(), slotId.length());
        }
        if (slotId.startsWith("dscombat.")) {
            return slotId.substring("dscombat.".length(), slotId.length());
        }
        return slotId;
    }

    public String getSlotId() {
        return PartSlot.getSlotId(this.slotId);
    }

    public String getTranslatableName() {
        if (this.slotId.startsWith("slotname.dscombat.")) {
            return this.slotId;
        }
        if (this.slotId.startsWith("dscombat.")) {
            return "slotname." + this.slotId;
        }
        return "slotname.dscombat." + this.slotId;
    }

    public SlotType getSlotType() {
        return this.type;
    }

    public String toString() {
        return "[" + this.slotId + ":" + this.getSlotType().toString() + ":" + String.valueOf(this.data) + "]";
    }

    public float getZRot() {
        return this.zRot;
    }

    public boolean isPilotSlot() {
        return PartSlot.isPilotSeat(this.getSlotId());
    }

    public boolean isCoPilotSlot() {
        return PartSlot.isCoPilotSeat(this.getSlotId());
    }

    public static boolean isPilotSeat(String slotId) {
        return slotId.equals(PILOT_SLOT_NAME) || slotId.equals("dscombat.pilot_seat") || slotId.equals("slotname.dscombat.pilot_seat");
    }

    public static boolean isCoPilotSeat(String slotId) {
        return slotId.equals(COPILOT_SLOT_NAME);
    }

    public String getLinkedHitbox() {
        return this.linkedHitbox;
    }

    public boolean isLinkedWithVehicleRoot() {
        return this.linkedHitbox.isEmpty();
    }

    public boolean isLinkedToHitbox(String hitboxName) {
        return this.linkedHitbox.equals(hitboxName);
    }
}

