/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartLoadRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartUnloadRecipe;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.WeaponPartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WeaponPartInstance<T extends WeaponPartStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    protected String weapon = "";
    private int ammo = 0;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new WeaponPartLoadRecipe(new class_2960("dscombat:weapon_part_load_recipe"));
    private static final PartItemUnloadRecipe<?> UNLOAD_RECIPE = new WeaponPartUnloadRecipe(new class_2960("dscombat:weapon_part_unload_recipe"));

    public WeaponPartInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        List<String> list;
        super.setFilled(param);
        if (param.isEmpty() && !(list = WeaponPresets.get().getCompatibleWeapons(this.getStatsId())).isEmpty()) {
            param = list.get(0);
        }
        this.weapon = param;
        this.ammo = ((WeaponPartStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setParamNotFilled(String param) {
        super.setParamNotFilled(param);
        this.weapon = param;
    }

    @Override
    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        if (tag.method_10545("weapon")) {
            this.weapon = tag.method_10558("weapon");
        } else if (tag.method_10545("weaponId")) {
            this.weapon = tag.method_10558("weaponId");
        }
        if (!WeaponPresets.get().has(this.weapon)) {
            this.weapon = "";
        }
        this.ammo = tag.method_10550("ammo");
    }

    @Override
    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10582("weapon", this.weapon);
        tag.method_10569("ammo", this.ammo);
        return tag;
    }

    @Override
    public void readBuffer(class_2540 buffer) {
        super.readBuffer(buffer);
        this.weapon = buffer.method_19772();
        this.ammo = buffer.readInt();
    }

    @Override
    public void writeBuffer(class_2540 buffer) {
        super.writeBuffer(buffer);
        buffer.method_10814(this.weapon);
        buffer.writeInt(this.ammo);
    }

    @Override
    public void setup(EntityVehicle craft, String slotId, class_243 pos) {
        WeaponInstance<?> data = craft.weaponSystem.get(this.weapon, slotId);
        if (data == null && WeaponPresets.get().has(this.weapon)) {
            data = WeaponPresets.get().get(this.weapon).createWeaponInstance();
            data.setSlot(slotId);
            craft.weaponSystem.addWeapon(data);
        }
        super.setup(craft, slotId, pos);
        if (data != null) {
            data.setMaxAmmo(((WeaponPartStats)this.getStats()).getMaxAmmo());
            data.setCurrentAmmo(this.ammo);
            data.setLaunchPos(pos);
            if (!craft.isClientSide()) {
                data.updateClientAmmo(craft);
            }
        }
    }

    @Override
    public void remove(EntityVehicle parent, String slotId) {
        super.remove(parent, slotId);
        parent.weaponSystem.removeWeapon(this.weapon, slotId);
    }

    @Override
    public void tick(String slotId) {
        super.tick(slotId);
        if (this.getParent() == null) {
            return;
        }
        WeaponInstance<?> data = this.getParent().weaponSystem.get(this.weapon, slotId);
        if (data != null) {
            this.ammo = data.getCurrentAmmo();
        }
    }

    @Override
    public void clientTick(String slotId) {
        super.clientTick(slotId);
        this.tick(slotId);
    }

    @Override
    public float getWeight() {
        float mass = super.getWeight();
        if (this.getParent() == null) {
            return mass;
        }
        WeaponInstance<?> data = this.getParent().weaponSystem.get(this.weapon, this.getSlotId());
        if (data == null) {
            return mass;
        }
        return mass + ((WeaponStats)data.getStats()).getMass() * (float)this.ammo;
    }

    @Override
    public float getCurrentAmmo() {
        return this.ammo;
    }

    @Override
    public float getMaxAmmo() {
        return ((WeaponPartStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        WeaponInstance<?> data;
        this.ammo = (int)ammo;
        if (this.getParent() != null && (data = this.getParent().weaponSystem.get(this.weapon, this.getSlotId())) != null) {
            data.setCurrentAmmo((int)ammo);
            if (!this.getParent().isClientSide()) {
                data.updateClientAmmo(this.getParent());
            }
        }
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return ((WeaponPartStats)this.getStats()).isWeaponCompatible(continuity);
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return true;
    }

    @Override
    public void setContinuity(String continuity) {
        if (this.getParent() != null && !Objects.equals(this.weapon, continuity)) {
            PartSlot slot = this.getParent().partsManager.getSlot(this.getSlotId());
            if (slot == null) {
                return;
            }
            slot.removePartData(this.getParent());
            this.weapon = continuity;
            slot.addPartData(this, this.getParent());
        }
        this.weapon = continuity;
    }

    @Override
    public String getContinuity() {
        return this.getWeaponId();
    }

    @Override
    public boolean isContinuityEmpty() {
        return this.getContinuity() == null || this.getContinuity().isEmpty() || this.getCurrentAmmo() == 0.0f;
    }

    public String getWeaponId() {
        return this.weapon;
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return UNLOAD_RECIPE;
    }
}

