/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.SeatStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class TurretStats
extends SeatStats {
    private final String[] compatible;
    private final float maxHealth;
    private final int maxAmmo;
    private final double weaponOffset;
    private final EntityTurret.ShootType shootType;
    private final RotBounds rotBounds;

    public TurretStats(class_2960 key, JsonObject json) {
        super(key, json);
        List<String> list = WeaponPresets.get().getCompatibleWeapons(this.getId());
        this.compatible = list.toArray(new String[list.size()]);
        this.maxHealth = UtilParse.getFloatSafe((JsonObject)json, (String)"maxHealth", (float)0.0f);
        this.maxAmmo = UtilParse.getIntSafe((JsonObject)json, (String)"maxAmmo", (int)0);
        this.weaponOffset = UtilParse.getFloatSafe((JsonObject)json, (String)"weaponOffset", (float)0.0f);
        this.shootType = (EntityTurret.ShootType)UtilParse.getEnumSafe((JsonObject)json, (String)"shootType", EntityTurret.ShootType.class);
        this.rotBounds = RotBounds.getFromJson(json);
    }

    @Override
    public JsonPresetType getType() {
        return PartType.TURRENT;
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new TurretInstance<TurretStats>(this);
    }

    public boolean isWeaponCompatible(String preset) {
        if (preset == null) {
            return false;
        }
        for (int i = 0; i < this.compatible.length; ++i) {
            if (!this.compatible[i].equals(preset)) continue;
            return true;
        }
        return false;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    @Override
    public class_1299<?> getDefaultExternalEntity() {
        return (class_1299)ModEntities.TURRET.get();
    }

    @Override
    public float getExternalEntityDefaultHealth() {
        return this.getMaxHealth();
    }

    public double getWeaponOffset() {
        return this.weaponOffset;
    }

    public EntityTurret.ShootType getShootType() {
        return this.shootType;
    }

    public RotBounds getRotBounds() {
        return this.rotBounds;
    }

    @Override
    public boolean isCraftableWeaponPart() {
        return true;
    }

    public static class RotBounds {
        public final float minRotX;
        public final float maxRotX;
        public final float rotRate;

        public static RotBounds create(float rotRate, float maxLookUpAngle, float maxLookDownAngle) {
            return new RotBounds(class_3532.method_15379((float)rotRate), -class_3532.method_15379((float)maxLookUpAngle), class_3532.method_15379((float)maxLookDownAngle));
        }

        private RotBounds(float rotRate, float minRotX, float maxRotX) {
            this.minRotX = minRotX;
            this.maxRotX = maxRotX;
            this.rotRate = rotRate;
        }

        public RotBounds(class_2487 tag) {
            this.minRotX = tag.method_10583("minRotX");
            this.maxRotX = tag.method_10583("maxRotX");
            this.rotRate = tag.method_10583("rotRate");
        }

        public void write(class_2487 tag) {
            tag.method_10548("minRotX", this.minRotX);
            tag.method_10548("maxRotX", this.maxRotX);
            tag.method_10548("rotRate", this.rotRate);
        }

        public RotBounds(class_2540 buffer) {
            this.minRotX = buffer.readFloat();
            this.maxRotX = buffer.readFloat();
            this.rotRate = buffer.readFloat();
        }

        public void write(class_2540 buffer) {
            buffer.writeFloat(this.minRotX);
            buffer.writeFloat(this.maxRotX);
            buffer.writeFloat(this.rotRate);
        }

        public static RotBounds getFromJson(JsonObject json) {
            JsonObject rotBounds = UtilParse.getJsonSafe((JsonObject)json, (String)"rotBounds");
            return new RotBounds(UtilParse.getFloatSafe((JsonObject)rotBounds, (String)"rotRate", (float)0.0f), UtilParse.getFloatSafe((JsonObject)rotBounds, (String)"minRotX", (float)0.0f), UtilParse.getFloatSafe((JsonObject)rotBounds, (String)"maxRotX", (float)0.0f));
        }

        public void writeToJson(JsonObject json) {
            JsonObject rotBounds = new JsonObject();
            rotBounds.addProperty("rotRate", (Number)Float.valueOf(this.rotRate));
            rotBounds.addProperty("minRotX", (Number)Float.valueOf(this.minRotX));
            rotBounds.addProperty("maxRotX", (Number)Float.valueOf(this.maxRotX));
            json.add("rotBounds", (JsonElement)rotBounds);
        }
    }
}

