/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.client.texture.VehicleDynamicTextures;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleTexture;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class VehicleTextureManager {
    public final EntityVehicle parent;
    private class_2960[] baseTextures;
    private TextureLayer[] textureLayers;
    private int baseTextureIndex = 0;
    private boolean changed;
    private class_2960 dynamicTexture;

    public VehicleTextureManager(EntityVehicle parent) {
        this.parent = parent;
        this.setupTextureLocations();
        this.dynamicTexture = this.getBaseTexture();
    }

    public void setupTextureLocations() {
        int i;
        this.baseTextures = new class_2960[((VehicleStats)this.parent.getStats()).baseTextureVariants];
        this.textureLayers = new TextureLayer[((VehicleStats)this.parent.getStats()).textureLayers];
        String namespace = ((VehicleStats)this.parent.getStats()).getNameSpace();
        for (i = 0; i < this.baseTextures.length; ++i) {
            this.baseTextures[i] = new class_2960(namespace + ":textures/entity/vehicle/" + this.parent.getAssetId() + "/base" + i + ".png");
        }
        for (i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i] = new TextureLayer(namespace + ":textures/entity/vehicle/" + this.parent.getAssetId() + "/layer" + i + ".png");
        }
    }

    public void setupDynamicTexture() {
        if (!this.parent.isClientSide()) {
            return;
        }
        this.dynamicTexture = VehicleDynamicTextures.createVehicleDynamicTexture(this.parent);
    }

    @Nullable
    public class_2960 getDynamicTexture() {
        return this.dynamicTexture;
    }

    public void onTick() {
        if (this.parent.isClientSide()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public void clientTick() {
        if (this.isChanged()) {
            new ToServerVehicleTexture(this.parent).sendToServer();
            this.setupDynamicTexture();
            this.resetChanged();
        }
    }

    public void serverTick() {
    }

    public void read(class_2487 entityNbt) {
        if (!entityNbt.method_10545("textures")) {
            return;
        }
        this.setupTextureLocations();
        class_2487 textures = entityNbt.method_10562("textures");
        this.setBaseTexture(textures.method_10550("baseTexture"));
        if (textures.method_10545("layers")) {
            class_2499 layers = textures.method_10554("layers", 10);
            for (int i = 0; i < this.textureLayers.length && i < layers.size(); ++i) {
                this.textureLayers[i].read(layers.method_10602(i));
            }
        }
        this.changed = false;
    }

    public void write(class_2487 entityNbt) {
        class_2487 textures = new class_2487();
        textures.method_10569("baseTexture", this.baseTextureIndex);
        class_2499 layers = new class_2499();
        for (TextureLayer layer : this.getTextureLayers()) {
            layers.add((Object)layer.write());
        }
        textures.method_10566("layers", (class_2520)layers);
        entityNbt.method_10566("textures", (class_2520)textures);
    }

    public void read(ByteBuf buffer) {
        this.setupTextureLocations();
        this.setBaseTexture(buffer.readInt());
        int layers = buffer.readInt();
        for (int i = 0; i < layers && i < this.textureLayers.length; ++i) {
            this.textureLayers[i].read(buffer);
        }
        this.setupDynamicTexture();
        this.changed = false;
    }

    public void write(class_2540 buffer) {
        buffer.writeInt(this.baseTextureIndex);
        buffer.writeInt(this.textureLayers.length);
        for (int i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i].write(buffer);
        }
    }

    public class_2960 getBaseTexture() {
        return this.baseTextures[this.baseTextureIndex];
    }

    public int getBaseTextureNum() {
        return this.baseTextures.length;
    }

    public int getBaseTextureIndex() {
        return this.baseTextureIndex;
    }

    public void setBaseTexture(int index) {
        if (index >= this.baseTextures.length || index < 0) {
            index = 0;
        }
        this.baseTextureIndex = index;
        this.changed = true;
    }

    public int getLayerNum() {
        return this.textureLayers.length;
    }

    public TextureLayer[] getTextureLayers() {
        return this.textureLayers;
    }

    public boolean isAllLayersDisabled() {
        for (int i = 0; i < this.getTextureLayers().length; ++i) {
            if (!this.getTextureLayers()[i].canRender()) continue;
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        for (int i = 0; i < this.textureLayers.length; ++i) {
            if (!this.textureLayers[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    public void resetChanged() {
        this.changed = false;
        for (int i = 0; i < this.textureLayers.length; ++i) {
            this.textureLayers[i].resetChanged();
        }
    }

    public static class TextureLayer {
        private final class_2960 texture;
        private BlendMode blendMode = BlendMode.ON_WHITE;
        private int colorInt;
        private Color color;
        private boolean enabled;
        private boolean changed;

        public TextureLayer(String texture) {
            this.texture = new class_2960(texture);
            this.setColor(UtilEntity.getRandomColor());
            this.changed = false;
        }

        public void read(class_2487 tag) {
            if (tag.method_10545("color")) {
                this.setColor(tag.method_10550("color"));
            }
            this.enabled = tag.method_10577("enabled");
            if (tag.method_10545("blendMode")) {
                this.blendMode = BlendMode.getByName(tag.method_10558("blendMode"));
            }
            this.changed = false;
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10569("color", this.colorInt);
            tag.method_10556("enabled", this.enabled);
            tag.method_10582("blendMode", this.blendMode.name());
            return tag;
        }

        public void read(ByteBuf buffer) {
            this.setColor(buffer.readInt());
            this.enabled = buffer.readBoolean();
            this.blendMode = BlendMode.values()[buffer.readInt()];
            this.changed = false;
        }

        public void write(class_2540 buffer) {
            buffer.writeInt(this.colorInt);
            buffer.writeBoolean(this.enabled);
            buffer.writeInt(this.blendMode.ordinal());
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public Color getColor() {
            return this.color;
        }

        public int getColorInt() {
            return this.colorInt;
        }

        public void setColor(int color) {
            this.colorInt = color;
            this.color = new Color(this.colorInt);
            this.changed = true;
        }

        public void setColor(String color) {
            try {
                this.setColor(Color.decode("0x" + color).getRGB());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public boolean canRender() {
            return this.enabled;
        }

        public void setCanRender(boolean render) {
            this.enabled = render;
            this.changed = true;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void resetChanged() {
            this.changed = false;
        }

        public BlendMode getBlendMode() {
            return this.blendMode;
        }

        public void setBlendMode(BlendMode mode) {
            this.blendMode = mode;
            this.changed = true;
        }
    }

    public static enum BlendMode {
        NONE,
        ON_WHITE,
        ON_ALL,
        SCALED,
        EVEN;


        public static BlendMode getByName(String name) {
            for (BlendMode mode : BlendMode.values()) {
                if (!mode.name().equals(name)) continue;
                return mode;
            }
            return NONE;
        }

        public String getTranslatable() {
            return "blendmode.dscombat." + this.name().toLowerCase();
        }
    }
}

