/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.entityscreen.VehicleScreenMapReader;
import com.onewhohears.dscombat.client.model.obj.HardCodedModelAnims;
import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.data.vehicle.EntityScreenData;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientType;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.data.jsonpreset.CustomAnimStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class VehicleClientStats
extends CustomAnimStats<ObjVehicleModel<EntityVehicle>, EntityVehicle> {
    private class_2960 background;
    private HashMap<String, UIPos> slotsPos;
    private List<EntityScreenData> screens;
    private boolean dontCull = false;

    public VehicleClientStats(class_2960 key, JsonObject json) {
        super(key, json);
    }

    protected ObjVehicleModel<EntityVehicle> createModel() {
        if (this.getJsonData().has("model_data")) {
            JsonObject model_data = this.getJsonData().get("model_data").getAsJsonObject();
            this.dontCull = UtilParse.getBooleanSafe((JsonObject)model_data, (String)"dont_cull", (boolean)false);
            if (model_data.has("hard_coded_model_anims")) {
                return HardCodedModelAnims.get(model_data.get("hard_coded_model_anims").getAsString());
            }
        }
        return new ObjVehicleModel<EntityVehicle>(this.getModelId(), this.getCustomAnims(), this.getKeyframeAnimIds());
    }

    public List<EntityScreenData> getScreens() {
        if (this.screens == null) {
            class_2960 screenMap = new class_2960(this.getNameSpace() + ":textures/entity/vehicle/" + this.getId() + "/screens.png");
            this.screens = VehicleScreenMapReader.generateScreens(screenMap, ((ObjVehicleModel)this.getModel()).modelId, UtilGeometry.convertVector((Vec3f)((ObjVehicleModel)this.getModel()).getGlobalPivot()));
        }
        return this.screens;
    }

    @Nullable
    public class_2960 getBackground() {
        if (!this.getJsonData().has("inventory_background")) {
            return null;
        }
        if (this.background == null) {
            this.background = new class_2960(this.getJsonData().get("inventory_background").getAsString());
        }
        return this.background;
    }

    public HashMap<String, UIPos> getSlotsPos() {
        if (this.slotsPos == null) {
            this.slotsPos = new HashMap();
            if (this.getJsonData().has("inventory_slots_pos")) {
                JsonArray isp = this.getJsonData().get("inventory_slots_pos").getAsJsonArray();
                for (int i = 0; i < isp.size(); ++i) {
                    JsonObject sp = isp.get(i).getAsJsonObject();
                    this.slotsPos.put(sp.get("slot_name").getAsString(), new UIPos(sp));
                }
            }
        }
        return this.slotsPos;
    }

    public UIPos getSlotPos(String slotId, int i, int x_start, int y_start) {
        if (!this.getSlotsPos().containsKey(slotId)) {
            return VehicleClientStats.getUIPosByIndex(i, x_start, y_start);
        }
        return this.getSlotsPos().get(slotId);
    }

    public boolean isDontCull() {
        return this.dontCull;
    }

    public static UIPos getUIPosByIndex(int i, int x_start, int y_start) {
        int x = x_start + i % 9 * 18;
        int y = y_start + i / 9 * 18;
        return new UIPos(x, y);
    }

    public JsonPresetType getType() {
        return VehicleClientType.STANDARD;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }

    public static class UIPos {
        private final int x;
        private final int y;

        public UIPos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        protected UIPos(JsonObject json) {
            this.x = json.get("slot_ui_x").getAsInt();
            this.y = json.get("slot_ui_y").getAsInt();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class Builder
    extends CustomAnimStats.CustomAnimStatsBuilder<Builder> {
        public Builder setDontCull(boolean dontCull) {
            this.getModelData().addProperty("dont_cull", Boolean.valueOf(dontCull));
            return this;
        }

        public Builder setHardCodedModelAnims(String hard_coded_model_anims) {
            this.getModelData().addProperty("hard_coded_model_anims", hard_coded_model_anims);
            return this;
        }

        public Builder setHardCodedModelAnims() {
            return this.setHardCodedModelAnims(this.getPresetId());
        }

        public Builder setBackground(String background) {
            return (Builder)this.setString("inventory_background", background);
        }

        public Builder addUIPos(String name, int x, int y) {
            if (!this.getData().has("inventory_slots_pos")) {
                this.getData().add("inventory_slots_pos", (JsonElement)new JsonArray());
            }
            JsonArray isp = this.getData().get("inventory_slots_pos").getAsJsonArray();
            JsonObject sp = new JsonObject();
            sp.addProperty("slot_name", name);
            sp.addProperty("slot_ui_x", (Number)x);
            sp.addProperty("slot_ui_y", (Number)y);
            isp.add((JsonElement)sp);
            return this;
        }

        public Builder setAllUIPos(int x_start, int y_start, int cols, String ... names) {
            int x = x_start;
            int y = y_start;
            for (int i = 0; i < names.length; ++i) {
                if (i != 0 && i % cols == 0) {
                    y += 18;
                    x = x_start;
                }
                this.addUIPos(names[i], x, y);
                x += 18;
            }
            return this;
        }

        protected Builder(String namespace, String name, VehicleClientType type) {
            super(namespace, name, (JsonPresetType)type);
        }

        protected Builder(String namespace, String name, VehicleClientType type, VehicleClientStats copy) {
            super(namespace, name, (JsonPresetType)type, (CustomAnimStats)copy);
        }

        public static Builder create(String namespace, String name) {
            return new Builder(namespace, name, VehicleClientType.STANDARD);
        }

        public static Builder createFromCopy(String namespace, String name, VehicleClientStats copy) {
            return new Builder(namespace, name, VehicleClientType.STANDARD, copy);
        }
    }
}

