/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.Config;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import org.slf4j.Logger;

public class RadarTargetTypes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static RadarTargetTypes instance;
    private List<Class<? extends class_1297>> radarMobClasses = new ArrayList<Class<? extends class_1297>>();

    public static RadarTargetTypes get() {
        if (instance == null) {
            instance = new RadarTargetTypes();
        }
        return instance;
    }

    public static void close() {
        instance = null;
    }

    private RadarTargetTypes() {
    }

    public void readConfig() {
        LOGGER.info("RadarTargetTypes READ CONFIG");
        this.readRadarMobs();
    }

    private void readRadarMobs() {
        this.radarMobClasses.clear();
        List mobList = (List)Config.COMMON.radarMobs.get();
        for (int i = 0; i < mobList.size(); ++i) {
            String className = (String)mobList.get(i);
            Class c = UtilEntity.getEntityClass((String)className);
            if (c == null) {
                LOGGER.warn("ERROR: " + className + " does not exist! Mob Radar will not look for it.");
                continue;
            }
            this.radarMobClasses.add(c);
            LOGGER.debug("ADDED MOB ENTITY CLASS: " + c.getName());
        }
    }

    public List<Class<? extends class_1297>> getRadarMobClasses() {
        return this.radarMobClasses;
    }
}

