/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.instance;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientOnShoot;
import com.onewhohears.dscombat.common.network.toclient.ToClientWeaponAmmo;
import com.onewhohears.dscombat.data.weapon.WeaponShootParameters;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class WeaponInstance<T extends WeaponStats>
extends JsonPresetInstance<T> {
    private int currentAmmo;
    private int recoilTime;
    private int maxAmmo;
    private class_243 pos = class_243.field_1353;
    private String failedLaunchReason;
    private String slotId = "";
    private boolean overrideGroundCheck = false;
    protected float changeLaunchPitch = 0.0f;
    @Nullable
    protected EntityWeapon<?> firedWeapon;

    public WeaponInstance(T stats) {
        super(stats);
    }

    public void readNBT(class_2487 tag) {
        super.readNBT(tag);
        this.currentAmmo = tag.method_10550("currentAmmo");
        this.maxAmmo = tag.method_10550("maxAmmo");
        this.slotId = tag.method_10558("slotId");
        this.pos = UtilParse.readVec3((class_2487)tag, (String)"pos");
    }

    public class_2487 writeNBT() {
        class_2487 tag = super.writeNBT();
        tag.method_10582("weaponId", this.getStatsId());
        tag.method_10569("currentAmmo", this.getCurrentAmmo());
        tag.method_10569("maxAmmo", this.getMaxAmmo());
        UtilParse.writeVec3((class_2487)tag, (class_243)this.pos, (String)"pos");
        tag.method_10582("slotId", this.slotId);
        return tag;
    }

    @Nullable
    public EntityWeapon<?> getEntity(class_1937 level) {
        class_1299<?> type = ((WeaponStats)this.getStats()).getEntityType();
        class_1297 entity = type.method_5883(level);
        if (entity instanceof EntityWeapon) {
            EntityWeapon w = (EntityWeapon)entity;
            w.setPreset(this.getStatsId());
            return w;
        }
        return null;
    }

    public EntityWeapon<?> getShootEntity(WeaponShootParameters params) {
        if (((WeaponStats)this.getStats()).isNoWeapon()) {
            this.setLaunchFail(null);
            return null;
        }
        if (!params.ignoreRecoil && !this.checkRecoil()) {
            this.setLaunchFail(null);
            return null;
        }
        if (!this.checkAmmo(1, params.owner)) {
            this.setLaunchFail("error.dscombat.no_ammo");
            return null;
        }
        if (params.vehicle != null && !this.overrideGroundCheck && !((WeaponStats)this.getStats()).canShootOnGround() && params.vehicle.isOnGround()) {
            this.setLaunchFail("error.dscombat.cant_shoot_on_ground");
            return null;
        }
        EntityWeapon<?> w = this.getEntity(params.level);
        if (w == null) {
            return null;
        }
        w.method_7432(params.owner);
        w.method_33574(params.pos);
        this.setDirection(w, params.direction);
        return w;
    }

    public void setDirection(EntityWeapon<?> weapon, class_243 direction) {
        float pitch = UtilAngles.getPitch((class_243)direction);
        float yaw = UtilAngles.getYaw((class_243)direction);
        weapon.method_36457(pitch - this.changeLaunchPitch);
        weapon.method_36456(yaw);
    }

    public boolean shootFromVehicle(class_1937 level, class_1297 owner, class_243 direction, EntityVehicle vehicle, boolean consume) {
        this.overrideGroundCheck = false;
        EntityWeapon<?> w = this.getShootEntity(new WeaponShootParameters(level, owner, vehicle.method_19538().method_1019(UtilAngles.rotateVector((class_243)this.getLaunchPos(), (QuaternionF)vehicle.getQ())), direction, vehicle, false, false));
        if (w == null) {
            return false;
        }
        level.method_8649(w);
        this.playShootSound(level, w.method_19538());
        this.setLaunchSuccess(1, owner, consume);
        this.updateClientAmmo(vehicle);
        vehicle.lastShootTime = vehicle.field_6012;
        EntityPart entityPart = vehicle.getPartBySlotId(this.getSlotId());
        if (entityPart instanceof EntityWeaponRack) {
            EntityWeaponRack rack = (EntityWeaponRack)entityPart;
            rack.lastShootTime = rack.field_6012;
            ToClientOnShoot.onShootWeaponRack(rack, owner);
        }
        this.firedWeapon = w;
        return true;
    }

    public boolean shootFromTurret(class_1937 level, class_1297 owner, class_243 direction, class_243 pos, @Nullable EntityVehicle vehicle, boolean consume) {
        return this.shootFromTurret(level, owner, direction, pos, vehicle, consume, false);
    }

    public boolean shootFromTurret(class_1937 level, class_1297 owner, class_243 direction, class_243 pos, @Nullable EntityVehicle vehicle, boolean consume, boolean ignoreRecoil) {
        this.overrideGroundCheck = true;
        EntityWeapon<?> w = this.getShootEntity(new WeaponShootParameters(level, owner, pos, direction, vehicle, ignoreRecoil, true));
        if (w == null) {
            return false;
        }
        level.method_8649(w);
        this.playShootSound(level, w.method_19538());
        this.setLaunchSuccess(1, owner, consume);
        if (vehicle != null && !ignoreRecoil) {
            vehicle.lastShootTime = vehicle.field_6012;
            EntityPart entityPart = vehicle.getPartBySlotId(this.getSlotId());
            if (entityPart instanceof EntityTurret) {
                EntityTurret turret = (EntityTurret)entityPart;
                turret.setLastShootTick(turret.field_6012);
                ToClientOnShoot.onShootTurret(turret, owner);
            }
        }
        this.firedWeapon = w;
        return true;
    }

    @Nullable
    public EntityWeapon<?> getFiredWeapon() {
        return this.firedWeapon;
    }

    public void playShootSound(class_1937 level, class_243 pos) {
        if (level.method_8608()) {
            return;
        }
        UtilSound.sendDelayedSound((class_3218)level, ((WeaponStats)this.getStats()).getShootSound(level.method_30349()), pos, 160.0f, 1.0f, 1.0f);
    }

    public void updateClientAmmo(EntityVehicle vehicle) {
        if (vehicle == null) {
            return;
        }
        if (vehicle.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientWeaponAmmo(vehicle.method_5628(), this.getStatsId(), this.slotId, this.getCurrentAmmo()), (class_1297)vehicle);
    }

    public void tick(@Nullable EntityVehicle parent, boolean isSelected) {
        if (this.recoilTime > 1) {
            --this.recoilTime;
        }
    }

    public boolean checkAmmo(int ammoNum, class_1297 shooter) {
        class_3222 p;
        if (shooter instanceof class_3222 && (p = (class_3222)shooter).method_7337()) {
            return true;
        }
        return this.getCurrentAmmo() >= ammoNum;
    }

    public boolean checkRecoil() {
        return this.recoilTime <= 1;
    }

    public class_243 getLaunchPos() {
        return this.pos;
    }

    public void setLaunchPos(class_243 pos) {
        this.pos = pos;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public void setMaxAmmo(int max) {
        this.maxAmmo = max;
    }

    public int getCurrentAmmo() {
        return this.currentAmmo;
    }

    public void forceSetCurrentAmmo(int currentAmmo) {
        this.currentAmmo = currentAmmo;
    }

    public void setCurrentAmmo(int currentAmmo) {
        if (currentAmmo < 0) {
            currentAmmo = 0;
        }
        if (currentAmmo > this.getMaxAmmo()) {
            currentAmmo = this.getMaxAmmo();
        }
        this.currentAmmo = currentAmmo;
    }

    public int addAmmo(int num) {
        int total = this.getCurrentAmmo() + num;
        int r = 0;
        if (total > this.getMaxAmmo()) {
            r = total - this.getMaxAmmo();
            total = this.getMaxAmmo();
        } else if (total < 0) {
            r = total;
            total = 0;
        }
        this.setCurrentAmmo(total);
        return r;
    }

    public void setChangeLaunchPitch(float degrees) {
        this.changeLaunchPitch = degrees;
    }

    public boolean isFailedLaunch() {
        return this.failedLaunchReason != null;
    }

    @Nullable
    public String getFailedLaunchReason() {
        return this.failedLaunchReason;
    }

    public void setLaunchSuccess(int ammoNum, class_1297 shooter, boolean consume) {
        this.failedLaunchReason = null;
        if (consume) {
            this.addAmmo(-ammoNum);
        }
        this.recoilTime = ((WeaponStats)this.getStats()).getFireRate();
    }

    public void setLaunchFail(String failedLaunchReason) {
        this.failedLaunchReason = failedLaunchReason;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public boolean isInternal() {
        return this.slotId == "";
    }

    public void setSlot(String slotId) {
        this.slotId = slotId;
    }

    public void setInternal() {
        this.slotId = "";
    }

    public boolean idMatch(String id, String slotId) {
        if (slotId == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.getStatsId().equals(id) && this.getSlotId().equals(slotId);
    }

    public boolean couldRadarWeaponTargetEntity(class_1297 entity, class_1297 radar) {
        return entity.method_5805() && !entity.method_7325() && !radar.method_5722(entity) && (double)radar.method_5739(entity) <= ((WeaponStats)this.getStats()).getMobTurretRange();
    }

    @Nullable
    public class_243 estimateImpactPosition(EntityVehicle vehicle) {
        if (!((WeaponStats)this.getStats()).isAimAssist()) {
            return null;
        }
        class_243 startPos = vehicle.method_19538().method_1019(UtilAngles.rotateVector((class_243)this.getLaunchPos(), (QuaternionF)vehicle.getQBySide()));
        class_243 startMove = this.getStartMove(vehicle);
        class_243 acc = this.getAcc(vehicle);
        double distSqr = 0.0;
        class_243 pos = startPos;
        class_243 move = startMove;
        while (distSqr <= 40000.0) {
            distSqr += move.method_1027();
            class_243 prevPos = pos;
            pos = pos.method_1019(move);
            if (pos.field_1351 < -64.0) {
                pos = new class_243(pos.field_1352, -64.0, pos.field_1350);
            }
            move = move.method_1019(acc);
            class_243 raycast = UtilEntity.raycastBlock((class_1937)vehicle.getWorld(), (class_243)prevPos, (class_243)pos);
            if (raycast == null) continue;
            return raycast;
        }
        return pos;
    }

    protected class_243 getStartMove(EntityVehicle vehicle) {
        return vehicle.method_18798();
    }

    protected class_243 getAcc(EntityVehicle vehicle) {
        return new class_243(0.0, -0.024525, 0.0);
    }
}

