/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.ai.goal;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TurretShootGoal
extends class_1352 {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    public static final ShootFunction CANT_SHOOT = (mob, turret, target, prevTargetPos) -> class_243.field_1353;
    public static final ShootFunction RANDOM_SHOOT = (mob, turret, target, prevTargetPos) -> {
        if (prevTargetPos == null || mob.field_6012 % 30 == 0) {
            prevTargetPos = mob.method_33571().method_1031((RANDOM.nextDouble() - 0.5) * 100.0, (RANDOM.nextDouble() - 0.25) * 30.0, (RANDOM.nextDouble() - 0.5) * 100.0);
        }
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        turret.shoot((class_1297)mob);
        return prevTargetPos;
    };
    public static final ShootFunction DUMBASS_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 20, 25.0f, false);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 360.0f, false, false)) {
            turret.shoot((class_1297)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction STUPID_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 10, 10.0f, false);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 20.0f, true, false)) {
            turret.shoot((class_1297)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction NORMAL_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 10, 5.0f, true);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 10.0f, true, true)) {
            turret.shoot((class_1297)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction SMART_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 8, 2.0f, true);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 5.0f, true, true)) {
            turret.shoot((class_1297)mob);
        }
        return prevTargetPos;
    };
    private final EntityTurret turret;
    private final class_1308 mob;
    private final ShootFunction shootFunction;
    private class_243 prevTargetPos;

    public static boolean debugTurretAI() {
        return (Boolean)Config.COMMON.logTurretAIDebug.get();
    }

    public static void lookAtPos(class_1308 mob, class_243 pos, EntityTurret turret) {
        UtilEntity.mobLookAtPos((class_1308)mob, (class_243)pos, (float)mob.method_20240());
        class_243 diff = pos.method_1020(mob.method_33571());
        float goalRotX = UtilAngles.getPitch((class_243)diff);
        float goalRotY = UtilAngles.getYaw((class_243)diff);
        turret.setOverrideLookAngles(goalRotX, goalRotY);
    }

    public static class_243 inaccurateShootPos(class_1308 mob, EntityTurret turret, class_1309 target, class_243 prevTargetPos, int updateRate, float inaccuracy, boolean accountGravity) {
        if (prevTargetPos == null || mob.field_6012 % updateRate == 0) {
            class_243 origin = turret.method_33571();
            class_243 targetPos = target.method_33571();
            WeaponInstance<?> wd = turret.getWeaponData();
            if (accountGravity && wd != null && ((WeaponStats)wd.getStats()).isBullet()) {
                double h;
                class_243 diff;
                double r;
                double div;
                double g;
                double z;
                double[] roots;
                double speed = ((BulletStats)wd.getStats()).getSpeed();
                if (speed <= 0.0) {
                    speed = 0.01;
                }
                if ((roots = UtilGeometry.rootsNoI((double)(z = 0.5 * (g = -0.024525) * (div = (r = (diff = targetPos.method_1020(origin)).method_37267()) / speed) * div), (double)r, (double)(z - (h = diff.field_1351)))) != null) {
                    double root = Math.min(roots[0], roots[1]);
                    targetPos = new class_243(targetPos.field_1352, origin.field_1351 + root * r, targetPos.field_1350);
                }
            }
            prevTargetPos = UtilGeometry.inaccurateTargetPos((class_243)origin, (class_243)targetPos, (float)inaccuracy);
        }
        return prevTargetPos;
    }

    public static boolean shouldShootTurret(EntityTurret turret, class_1309 target, class_243 targetPos, float aimError, boolean useIRMis, boolean useTrackMis) {
        boolean trackMissile;
        WeaponInstance<?> wd = turret.getWeaponData();
        if (wd == null) {
            if (TurretShootGoal.debugTurretAI()) {
                LOGGER.info("NO SHOOT weapon data null");
            }
            return false;
        }
        if (!wd.checkRecoil() || wd.getCurrentAmmo() <= 0) {
            return false;
        }
        boolean irMissile = useIRMis && ((WeaponStats)wd.getStats()).isIRMissile();
        boolean bl = trackMissile = useTrackMis && ((WeaponStats)wd.getStats()).requiresRadar();
        if (irMissile || trackMissile) {
            double nextShootTime;
            int shootTimeDiff = turret.field_6012 - turret.getLastShootTick();
            if ((double)shootTimeDiff < (nextShootTime = Math.min((double)((WeaponStats)wd.getStats()).getMaxAge() * 0.1, 120.0))) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT already shoot recently {} < {}", (Object)shootTimeDiff, (Object)nextShootTime);
                }
                return false;
            }
            EntityWeapon<?> weapon = turret.getFiredWeapon();
            if (weapon != null && (!weapon.method_31481() || weapon.isDiscardedButTicking())) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT weapon still alive {}", weapon);
                }
                return false;
            }
        }
        if (irMissile) {
            if (UtilVehicleEntity.isOnGroundOrWater((class_1297)target)) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT target in on ground or in water");
                }
                return false;
            }
            aimError += 6.0f;
        } else if (trackMissile) {
            EntityVehicle vehicle = turret.getParentVehicle();
            if (vehicle == null) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT parent vehicle null");
                }
                return false;
            }
            if (!vehicle.radarSystem.hasRadar()) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT no radar");
                }
                return false;
            }
            if (!vehicle.radarSystem.hasTarget((class_1297)target)) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT does not have radar target");
                }
                return false;
            }
            vehicle.radarSystem.selectTarget((class_1297)target);
            aimError += 3.0f;
        }
        class_243 turretLook = turret.method_5720();
        class_243 diff = targetPos.method_1020(turret.method_33571());
        double angle = UtilGeometry.angleBetweenDegrees((class_243)diff, (class_243)turretLook);
        if (angle > (double)aimError) {
            if (TurretShootGoal.debugTurretAI()) {
                LOGGER.info("NO SHOOT not looking close enough {} > {}", (Object)angle, (Object)Float.valueOf(aimError));
            }
            return false;
        }
        if (TurretShootGoal.debugTurretAI()) {
            LOGGER.info("SHOULD SHOOT");
        }
        return true;
    }

    public static ShootFunction getShootFunctionByMob(class_1308 mob) {
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_SHOOT_SMART)) {
            return SMART_SHOOT;
        }
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_SHOOT_NORMAL)) {
            return NORMAL_SHOOT;
        }
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_SHOOT_STUPID)) {
            return STUPID_SHOOT;
        }
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_SHOOT_DUMBASS)) {
            return DUMBASS_SHOOT;
        }
        if (mob.method_5864().method_20210(ModTags.EntityTypes.TURRET_SHOOT_RANDOM)) {
            return RANDOM_SHOOT;
        }
        return CANT_SHOOT;
    }

    public TurretShootGoal(class_1308 mob, EntityTurret turret) {
        this(mob, turret, TurretShootGoal.getShootFunctionByMob(mob));
    }

    public TurretShootGoal(class_1308 mob, EntityTurret turret, ShootFunction shootFunction) {
        this.mob = mob;
        this.turret = turret;
        this.shootFunction = shootFunction;
    }

    public void method_6268() {
        super.method_6268();
        class_1309 target = this.mob.method_5968();
        if (TurretShootGoal.debugTurretAI()) {
            LOGGER.info("shoot goal tick {}", (Object)target);
        }
        if (target == null) {
            this.prevTargetPos = null;
            return;
        }
        this.prevTargetPos = this.shootFunction.shoot(this.mob, this.turret, target, this.prevTargetPos);
    }

    public boolean method_6264() {
        if (!UtilEntity.getLevel((class_1297)this.mob).method_8450().method_8355(DSCGameRules.MOBS_USE_TURRETS)) {
            return false;
        }
        if (this.mob.method_5854() == null || !this.mob.method_5854().equals((Object)this.turret)) {
            return false;
        }
        class_1309 target_entity = this.mob.method_5968();
        return target_entity != null && target_entity.method_5805();
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6270() {
        super.method_6270();
        this.prevTargetPos = null;
    }

    public boolean method_38846() {
        return true;
    }

    public static interface ShootFunction {
        @NotNull
        public class_243 shoot(class_1308 var1, EntityTurret var2, @NotNull class_1309 var3, @Nullable class_243 var4);
    }
}

