/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.ai.goal;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.ai.goal.TurretShootGoal;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class TurretTargetGoal<T extends class_1309>
extends class_1400<T> {
    private final Predicate<class_1309> check;
    private final EntityTurret turret;
    private final double range;

    public static TurretTargetGoal<class_1657> targetPlayers(class_1308 mob, EntityTurret turret) {
        double range = turret.getAIHorizontalRange();
        return new TurretTargetGoal<class_1657>(mob, turret, class_1657.class, range, TurretTargetGoal.checkCanTarget(mob, turret, false));
    }

    public static TurretTargetGoal<class_1309> targetEnemy(class_1308 mob, EntityTurret turret) {
        double range = turret.getAIHorizontalRange();
        return new TurretTargetGoal<class_1309>(mob, turret, class_1309.class, range, TurretTargetGoal.checkCanTarget(mob, turret, true));
    }

    public static Predicate<class_1309> checkCanTarget(class_1308 mob, EntityTurret turret, boolean enemyCheck) {
        return entity -> {
            WeaponInstance<?> wd;
            if (TurretShootGoal.debugTurretAI()) {
                TurretShootGoal.LOGGER.info("turret {} checking {}", (Object)turret, entity);
            }
            if ((wd = turret.getWeaponData()) == null) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL weapon instance null");
                }
                return false;
            }
            if (entity == null) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity null");
                }
                return false;
            }
            if (entity.method_31481()) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity removed");
                }
                return false;
            }
            if (entity.method_29504()) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity dead or dying");
                }
                return false;
            }
            if (entity.method_7325()) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity is spectator");
                }
                return false;
            }
            if (entity.method_19538().method_1020(turret.method_19538()).method_37267() > turret.getAIHorizontalRange()) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity outside of range {}", (Object)turret.getAIHorizontalRange());
                }
                return false;
            }
            if (entity.method_5722((class_1297)mob)) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity is allied");
                }
                return false;
            }
            if (mob.method_5794((class_1297)entity)) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL entity is passenger of the same vehicle of the mob");
                }
                return false;
            }
            boolean isPlayer = false;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                isPlayer = true;
                if (player.method_7337()) {
                    if (TurretShootGoal.debugTurretAI()) {
                        TurretShootGoal.LOGGER.info("FAIL player is creative");
                    }
                    return false;
                }
            }
            if (enemyCheck) {
                if (mob.method_5781() == null && isPlayer) {
                    if (TurretShootGoal.debugTurretAI()) {
                        TurretShootGoal.LOGGER.info("FAIL team null and is player");
                    }
                    return false;
                }
                if (!(entity instanceof class_1569)) {
                    if (TurretShootGoal.debugTurretAI()) {
                        TurretShootGoal.LOGGER.info("FAIL not an enemy");
                    }
                    return false;
                }
            }
            if (((WeaponStats)wd.getStats()).isIRMissile()) {
                if (UtilVehicleEntity.isOnGroundOrWater((class_1297)entity)) {
                    return false;
                }
            } else if (((WeaponStats)wd.getStats()).requiresRadar()) {
                EntityVehicle vehicle = turret.getParentVehicle();
                if (vehicle == null) {
                    if (TurretShootGoal.debugTurretAI()) {
                        TurretShootGoal.LOGGER.info("FAIL vehicle null");
                    }
                    return false;
                }
                if (!vehicle.radarSystem.hasTarget((class_1297)entity)) {
                    if (TurretShootGoal.debugTurretAI()) {
                        TurretShootGoal.LOGGER.info("FAIL radar doesn't have target");
                    }
                    return false;
                }
            }
            if (!UtilEntity.canEntitySeeEntity((class_1297)mob, (class_1297)entity, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()))) {
                if (TurretShootGoal.debugTurretAI()) {
                    TurretShootGoal.LOGGER.info("FAIL cant see target");
                }
                return false;
            }
            return true;
        };
    }

    protected void method_18415() {
        if (TurretShootGoal.debugTurretAI()) {
            TurretShootGoal.LOGGER.info("find target {}", (Object)this.field_6660);
        }
        WeaponInstance<?> wd = this.turret.getWeaponData();
        EntityVehicle vehicle = this.turret.getParentVehicle();
        if (wd == null || vehicle == null) {
            return;
        }
        if (((WeaponStats)wd.getStats()).requiresRadar()) {
            this.field_6644 = this.field_6643 != class_1657.class && this.field_6643 != class_3222.class ? vehicle.radarSystem.getLivingTargetByWeapon(wd) : vehicle.radarSystem.getPlayerTargetByWeapon(wd);
            if (TurretShootGoal.debugTurretAI()) {
                TurretShootGoal.LOGGER.info("target = {}", (Object)this.field_6644);
            }
            this.field_6660.method_5980(this.field_6644);
            return;
        }
        class_1937 level = UtilEntity.getLevel((class_1297)this.field_6660);
        this.field_6644 = this.field_6643 != class_1657.class && this.field_6643 != class_3222.class ? level.method_18468(level.method_8390(this.field_6643, this.method_6321(this.method_6326()), entity -> true), this.field_6642, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321()) : level.method_18463(this.field_6642, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
        this.field_6660.method_5980(this.field_6644);
    }

    public boolean method_6264() {
        if (TurretShootGoal.debugTurretAI()) {
            TurretShootGoal.LOGGER.info("canUse? {}", (Object)this.field_6660);
        }
        if (!UtilEntity.getLevel((class_1297)this.field_6660).method_8450().method_8355(DSCGameRules.MOBS_USE_TURRETS)) {
            return false;
        }
        if (this.field_6660.method_5854() == null || !this.field_6660.method_5854().equals((Object)this.turret)) {
            return false;
        }
        return super.method_6264();
    }

    public boolean method_6266() {
        class_1309 living = this.field_6660.method_5968();
        if (living == null) {
            living = this.field_6644;
        }
        if (living == null) {
            return false;
        }
        if (this.field_6660.method_29504()) {
            return false;
        }
        if (!this.check.test(living)) {
            if (TurretShootGoal.debugTurretAI()) {
                TurretShootGoal.LOGGER.info("cant continue to use {} {}", (Object)this.field_6660, (Object)this.field_6660.method_5968());
            }
            return false;
        }
        this.field_6660.method_5980(living);
        this.field_6644 = living;
        if (TurretShootGoal.debugTurretAI()) {
            TurretShootGoal.LOGGER.info("canContinueToUse {} {}", (Object)this.field_6660, (Object)this.field_6660.method_5968());
        }
        return true;
    }

    public void method_6270() {
        this.field_6660.method_5980(null);
        this.field_6644 = null;
    }

    private TurretTargetGoal(class_1308 mob, EntityTurret turret, Class<T> type, double range, Predicate<class_1309> check) {
        super(mob, type, 8, false, false, check);
        this.turret = turret;
        this.range = range;
        this.check = check;
        this.field_6642.method_36627();
    }

    @NotNull
    protected class_238 method_6321(double targetDistance) {
        return this.field_6660.method_5829().method_1009(this.method_6326(), this.getVerticalRange(), this.method_6326());
    }

    public double getVerticalRange() {
        return this.turret.getAIVerticalRange();
    }

    protected double method_6326() {
        return this.range;
    }
}

