/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.WeaponExternalInstance;
import com.onewhohears.dscombat.data.parts.stats.WeaponExternalStats;
import com.onewhohears.dscombat.data.weapon.client.WeaponAssets;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientStats;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.class_1299;
import net.minecraft.class_1937;

public class EntityWeaponRack
extends EntityPart<WeaponExternalStats, WeaponExternalInstance<WeaponExternalStats>> {
    private String weaponModelId;
    public int lastShootTime;

    public EntityWeaponRack(class_1299<?> type, class_1937 level) {
        super(type, level, "xm12");
    }

    public int getAmmoNum() {
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle == null) {
            return 0;
        }
        WeaponInstance<?> wd = vehicle.weaponSystem.get(this.getSlotId());
        if (wd == null) {
            return 0;
        }
        return wd.getCurrentAmmo();
    }

    public String getWeaponModelId() {
        if (this.weaponModelId == null) {
            this.weaponModelId = "";
            EntityVehicle vehicle = this.getParentVehicle();
            if (vehicle == null) {
                return this.weaponModelId;
            }
            WeaponInstance<?> wd = vehicle.weaponSystem.get(this.getSlotId());
            if (wd == null) {
                return this.weaponModelId;
            }
            String assetId = ((WeaponStats)wd.getStats()).getAssetId();
            WeaponClientStats assets = WeaponAssets.get().get(assetId);
            if (assets == null) {
                return this.weaponModelId;
            }
            this.weaponModelId = assets.getModelId();
        }
        return this.weaponModelId;
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    protected double getClientRenderDistance() {
        return (Double)Config.CLIENT.renderWeaponRackDistance.get();
    }

    @Override
    public PartType getPartType() {
        return PartType.EXTERNAL_WEAPON;
    }

    @Override
    public boolean canGetHurt() {
        return false;
    }

    public void onClientShoot() {
        this.lastShootTime = this.field_6012;
    }
}

