/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;

public class EntityBoat
extends EntityVehicle {
    protected double waterLevel;

    public EntityBoat(class_1299<? extends EntityBoat> entity, class_1937 level, String defaultPreset) {
        super(entity, level, defaultPreset);
        this.field_6013 = 0.2f;
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.BOAT;
    }

    @Override
    public void applyGroundBreaks() {
    }

    @Override
    public void applyAirBreaks() {
        this.throttleToZero();
        this.inputs.setThrottleOverride(this.getCurrentThrottle(), this);
        super.applyAirBreaks();
    }

    @Override
    public boolean canGroundBrake() {
        return this.method_5799() && ((VehicleStats)this.getStats()).break_deacc_air > 0.0f && this.isOperational();
    }

    @Override
    public boolean canAirBrake() {
        return false;
    }

    public boolean canWaterBrake() {
        return this.method_5799() && ((VehicleStats)this.getStats()).break_deacc_air > 0.0f && this.isOperational();
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public void calcWaterMovement(QuaternionF q) {
        super.calcWaterMovement(q);
        if (!this.checkInWater()) {
            return;
        }
        this.flatten(q, 2.0f, 2.0f, true);
        this.tickFloat();
        if (this.canWaterBrake() && this.isAirBreaking()) {
            this.applyAirBreaks();
        }
    }

    protected void tickFloat() {
        class_243 weightF = this.getWeightForce();
        float F = this.method_17681() * this.method_17681() * 8000.0f;
        float maxF = F * this.method_17682();
        if ((double)maxF < Math.abs(weightF.field_1351)) {
            this.forces = this.forces.method_1031(0.0, (double)maxF, 0.0);
            return;
        }
        if (!this.couldFloat()) {
            this.forces = this.forces.method_1019(weightF.method_1021(-0.9));
            return;
        }
        double bbMin = this.method_5829().field_1322;
        double actualF = (double)F * (this.waterLevel - bbMin);
        class_243 floatF = new class_243(0.0, actualF, 0.0);
        this.forces = this.forces.method_1019(floatF);
        class_243 move = this.method_18798();
        double stableDisplacement = Math.abs(weightF.field_1351) / (double)F;
        double stableY = this.waterLevel - stableDisplacement;
        double stableDiff = stableY - bbMin;
        if (Math.abs(move.field_1351) < 0.1 && Math.abs(stableDiff) < 0.1) {
            double posBBDiff = this.method_23318() - bbMin;
            this.method_5814(this.method_19538().field_1352, stableY + posBBDiff, this.method_19538().field_1350);
            move = move.method_18805(1.0, 0.0, 1.0);
            this.forces = this.forces.method_18805(1.0, 0.0, 1.0);
        } else if (stableDiff > 0.0 && move.field_1351 == 0.0) {
            this.method_33574(this.method_19538().method_1031(0.0, this.forces.field_1351 / (double)this.getTotalMass(), 0.0));
        } else {
            move = move.method_18805(1.0, 0.9, 1.0);
        }
        this.method_18799(move);
    }

    public double getFloatSpeed() {
        return 0.02;
    }

    @Override
    public boolean isGroundBraking() {
        return this.inputs.special;
    }

    public boolean couldFloat() {
        return this.isOperational();
    }

    protected boolean checkInWater() {
        class_238 aabb = this.method_5829();
        int i = class_3532.method_15357((double)aabb.field_1323);
        int j = class_3532.method_15384((double)aabb.field_1320);
        int k = class_3532.method_15357((double)aabb.field_1322);
        int l = class_3532.method_15384((double)aabb.field_1325);
        int i1 = class_3532.method_15357((double)aabb.field_1321);
        int j1 = class_3532.method_15384((double)aabb.field_1324);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        class_2338.class_2339 mbp = new class_2338.class_2339();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    mbp.method_10103(k1, l1, i2);
                    class_3610 fluidstate = this.getWorld().method_8316((class_2338)mbp);
                    if (!fluidstate.method_15767(class_3486.field_15517)) continue;
                    float f = (float)l1 + fluidstate.method_15763((class_1922)this.getWorld(), (class_2338)mbp);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag = aabb.field_1322 < (double)f;
                }
            }
        }
        return flag;
    }

    @Override
    public double getMaxSpeedForMotion() {
        float th = this.getCurrentThrottle();
        double max = super.getMaxSpeedForMotion();
        if (th < 0.0f) {
            return max * 0.25;
        }
        return max;
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.boatSpeedFactor.get();
    }

    @Override
    public double getPushThrustMag() {
        return super.getPushThrustMag();
    }

    @Override
    public class_243 getThrustForce(QuaternionF q) {
        if (!this.method_5799()) {
            return class_243.field_1353;
        }
        class_243 direction = UtilAngles.getRollAxis((QuaternionF)q);
        return direction.method_1021(this.getPushThrustMag());
    }

    @Override
    public double getDragArea() {
        double area = super.getDragArea();
        if (this.method_5799()) {
            double angle = UtilGeometry.angleBetweenDegrees((class_243)this.method_18798(), (class_243)this.method_5720());
            area = Math.max(area * 0.025, area * Math.sin(0.01745329238474369 * angle));
        }
        return area;
    }

    @Override
    public boolean isLandingGear() {
        return false;
    }

    @Override
    public void waterDamage() {
        if (this.waterLevel > this.method_5829().field_1325) {
            super.waterDamage();
        }
    }

    @Override
    public boolean canOpenPartsMenu() {
        return (double)this.xzSpeed < 0.1 || this.isTestMode();
    }

    @Override
    public String getOpenMenuError() {
        return "error.dscombat.no_menu_moving";
    }

    @Override
    public boolean canToggleLandingGear() {
        return false;
    }

    @Override
    public boolean isPitchControllable() {
        return false;
    }

    @Override
    public boolean isRollControllable() {
        return false;
    }

    @Override
    public boolean canDriveOnGround() {
        return false;
    }

    @Override
    public boolean ignoreToItemFlyCheck() {
        return true;
    }
}

