/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle.wind_tunnel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.WindTunnelJob;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.JsonPresetEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityWindTunnel
extends JsonPresetEntity<VehicleStats> {
    public static final class_2940<String> PRESET = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13326);
    public static final class_2940<class_243> SPEED = class_2945.method_12791(EntityWindTunnel.class, DataSerializers.VEC3);
    public static final class_2940<QuaternionF> Q = class_2945.method_12791(EntityWindTunnel.class, DataSerializers.QUATERNION);
    public static final class_2940<Float> THROTTLE = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> AFTERBURNER = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HIDE_MODEL = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> ALTITUDE = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13320);
    public static final class_2940<class_243> INPUTS = class_2945.method_12791(EntityWindTunnel.class, DataSerializers.VEC3);
    public static final class_2940<class_2487> OVERRIDES = class_2945.method_12791(EntityWindTunnel.class, (class_2941)class_2943.field_13318);
    @Nullable
    private EntityVehicle vehicle;
    @Nullable
    public WindTunnelJob job;
    public class_243 totalAcc = class_243.field_1353;
    public class_243 weightAcc = class_243.field_1353;
    public class_243 thrustAcc = class_243.field_1353;
    public class_243 dragAcc = class_243.field_1353;
    public class_243 liftAcc = class_243.field_1353;
    public class_243 rotAcc = class_243.field_1353;
    public double windCompAcc;
    public double centripetalAcc;
    public double yawRate;
    public double turnRadius;
    public final List<Float> aoas = new ArrayList<Float>();

    public EntityWindTunnel(class_1299<?> type, class_1937 level) {
        super(type, level, "alexis_plane_unarmed");
        this.field_5960 = true;
    }

    public void startFindMultiLiftDragJob(float altitude) {
        this.chatToNearbyPlayers("Starting Multi Find Lift/Drag Coefficients Job...", class_124.field_1076);
        this.setQ(UtilAngles.toQuaternionF((double)0.0, (double)0.0, (double)90.0));
        this.setThrottle(1.0f);
        this.setAfterBurner(true);
        this.setAltitude(altitude);
        this.setInputs(new class_243(0.0, 0.0, 0.0));
        JsonArray array = new JsonArray();
        class_2499 speeds = ((class_2487)this.field_6011.method_12789(OVERRIDES)).method_10554("speeds", 6);
        class_2499 aoas = ((class_2487)this.field_6011.method_12789(OVERRIDES)).method_10554("aoas", 6);
        class_2499 turn_rates = ((class_2487)this.field_6011.method_12789(OVERRIDES)).method_10554("turn_rates", 6);
        if (aoas.size() != turn_rates.size() || aoas.size() != speeds.size()) {
            this.chatToNearbyPlayers("WARNING: Not all lists are the same length! aoas: " + aoas.size() + " speeds: " + speeds.size() + " turn_rates: " + turn_rates.size(), class_124.field_1061);
        }
        int l = Math.min(Math.min(aoas.size(), turn_rates.size()), speeds.size());
        for (int i = 0; i < l; ++i) {
            JsonObject data = new JsonObject();
            data.addProperty("speed", (Number)speeds.method_10611(i));
            data.addProperty("aoa", (Number)aoas.method_10611(i));
            data.addProperty("turn_rate", (Number)turn_rates.method_10611(i));
            array.add((JsonElement)data);
        }
        this.job = new WindTunnelJob.MultiLiftDragJob(array);
    }

    public void setSpeedList(double[] speeds) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        overrides.method_10566("speeds", (class_2520)EntityWindTunnel.doubleArrayToListTag(speeds));
        this.field_6011.method_12778(OVERRIDES, (Object)overrides);
    }

    public void setAOAList(double[] aoas) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        overrides.method_10566("aoas", (class_2520)EntityWindTunnel.doubleArrayToListTag(aoas));
        this.field_6011.method_12778(OVERRIDES, (Object)overrides);
    }

    public void setTurnRateList(double[] turnRates) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        overrides.method_10566("turn_rates", (class_2520)EntityWindTunnel.doubleArrayToListTag(turnRates));
        this.field_6011.method_12778(OVERRIDES, (Object)overrides);
    }

    public static class_2499 doubleArrayToListTag(double[] a) {
        class_2499 list = new class_2499();
        for (int i = 0; i < a.length; ++i) {
            list.method_10533(i, (class_2520)class_2489.method_23241((double)a[i]));
        }
        return list;
    }

    public void startFindLiftDragJob(float speed, float turn_rate, float aoa, float altitude) {
        this.chatToNearbyPlayers("Starting Find Lift/Drag Coefficients Job...", class_124.field_1076);
        this.chatToNearbyPlayers("Speed = " + speed + " | Turn Rate = " + turn_rate + " | AOA = " + aoa + " | Altitude = " + altitude, class_124.field_1075);
        this.setSpeed(new class_243(0.0, 0.0, (double)speed));
        this.setQ(UtilAngles.toQuaternionF((double)aoa, (double)0.0, (double)90.0));
        this.setThrottle(1.0f);
        this.setAfterBurner(true);
        this.setAltitude(altitude);
        this.setInputs(new class_243(0.0, 0.0, 0.0));
        this.job = new WindTunnelJob.FindLiftDragJob(aoa, turn_rate);
    }

    public void setOverrideValue(String name, class_2487 value) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        overrides.method_10566(name, (class_2520)value);
        this.field_6011.method_12778(OVERRIDES, (Object)overrides);
    }

    public void clearOverrideValue(String name) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        overrides.method_10551(name);
        this.field_6011.method_12778(OVERRIDES, (Object)overrides);
    }

    public class_2487 getOverrideValue(String name) {
        class_2487 overrides = (class_2487)this.field_6011.method_12789(OVERRIDES);
        if (overrides.method_10545(name)) {
            return overrides.method_10562(name);
        }
        return null;
    }

    public void chatToNearbyPlayers(String msg) {
        this.chatToNearbyPlayers((class_2561)UtilMCText.literal((String)msg));
    }

    public void chatToNearbyPlayers(String msg, class_124 color) {
        class_5250 comp = UtilMCText.literal((String)msg);
        comp.method_10862(class_2583.field_24360.method_10977(color));
        this.chatToNearbyPlayers((class_2561)comp);
    }

    public void chatToNearbyPlayers(class_2561 msg) {
        class_238 bb = this.method_5829().method_1014(16.0);
        for (class_1657 player : this.getWorld().method_18456()) {
            if (!bb.method_1008(player.method_23317(), player.method_23318(), player.method_23321())) continue;
            player.method_7353(msg, false);
        }
    }

    public class_1937 getWorld() {
        return UtilEntity.getLevel((class_1297)this);
    }

    public void method_5773() {
        if (!this.getWorld().method_8608() && this.job != null) {
            this.job.tick(this);
        }
        this.tickSimulate();
    }

    protected void tickSimulate() {
        class_243 speed = this.getSpeed();
        QuaternionF q = this.getQ();
        EntityVehicle vehicle = this.getSimulatedVehicle();
        vehicle.setTestMode(true);
        vehicle.method_33574(this.method_19538().method_18805(1.0, 0.0, 1.0).method_1031(0.0, (double)(this.getAltitude() + (float)UtilEntity.getSeaLevel((class_1937)this.getWorld())), 0.0));
        vehicle.setQBySide(q);
        vehicle.method_18799(speed);
        vehicle.setCurrentThrottle(this.getThrottle());
        vehicle.setUseAfterBurnerOverride(this.getAfterBurner());
        vehicle.tickPhysics();
        vehicle.updateEulerAngles();
        vehicle.setLandingGear(false);
        vehicle.foldLandingGearNow();
        if (this.getWorld().method_8608()) {
            vehicle.clientTick();
        }
        class_243 i = this.getInputs();
        vehicle.inputs.pitch = (float)i.field_1352;
        vehicle.inputs.yaw = (float)i.field_1351;
        vehicle.inputs.roll = (float)i.field_1350;
        this.totalAcc = vehicle.getAccFromForce(vehicle.getForces());
        this.weightAcc = vehicle.getAccFromForce(vehicle.getWeightForce());
        this.thrustAcc = vehicle.getAccFromForce(vehicle.getThrustForce(q));
        this.dragAcc = vehicle.getAccFromForce(vehicle.getDragForce(q));
        this.liftAcc = class_243.field_1353;
        this.aoas.clear();
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            this.dragAcc = this.dragAcc.method_1019(vehicle.getAccFromForce(phy.getDragForce()));
            this.liftAcc = this.liftAcc.method_1019(vehicle.getAccFromForce(phy.getLiftForce()));
            this.aoas.add(Float.valueOf(phy.getAOA()));
        }
        this.windCompAcc = UtilGeometry.vecCompMagDirByAxis((class_243)this.totalAcc, (class_243)speed);
        class_243 cenAxis = UtilAngles.getRollAxis((double)0.0, (double)((vehicle.method_36454() + 90.0f) * ((float)Math.PI / 180)));
        this.centripetalAcc = UtilGeometry.vecCompMagDirByNormAxis((class_243)this.liftAcc, (class_243)cenAxis);
        this.yawRate = this.centripetalAcc / (double)vehicle.getXZSpeed() * 57.2957763671875;
        this.turnRadius = (double)vehicle.getXZSpeed() / (this.yawRate * 0.01745329238474369);
        class_243 m = vehicle.getMoment();
        class_243 I = vehicle.getTotalRotInertia();
        this.rotAcc = new class_243(m.field_1352 / I.field_1352, m.field_1351 / I.field_1351, m.field_1350 / I.field_1350).method_1021(vehicle.getAccTimeScale());
    }

    @NotNull
    public EntityVehicle getSimulatedVehicle() {
        if (this.vehicle == null || this.getStatsHolder().getHolderReloads() != this.getPresets().getReloads() || !this.vehicle.getStatsId().equals(this.getStatsId())) {
            this.vehicle = this.createVehicleToSimulate();
        }
        return this.vehicle;
    }

    private EntityVehicle createVehicleToSimulate() {
        this.verifyCurrentPresetId();
        VehicleStats stats = (VehicleStats)this.getStats();
        class_1299<? extends EntityVehicle> entityType = stats.getEntityType();
        EntityVehicle vehicle = (EntityVehicle)entityType.method_5883(this.getWorld());
        vehicle.setPreset(this.getStatsId());
        vehicle.updatePhysicsInstances();
        vehicle.partsManager.read(stats.getDataAsNBT(), stats.getDataAsNBT());
        if (this.getWorld().method_8608()) {
            vehicle.partsManager.clientPartsSetup();
            vehicle.textureManager.setupTextureLocations();
            vehicle.textureManager.setupDynamicTexture();
        } else {
            vehicle.partsManager.setupParts();
        }
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            phy.setWindTunnel(this);
        }
        return vehicle;
    }

    public void verifyCurrentPresetId() {
        if (!VehiclePresets.get().has(this.getStatsId())) {
            this.setPreset("wooden_plane");
        }
    }

    protected void method_5693() {
        this.field_6011.method_12784(SPEED, (Object)class_243.field_1353);
        this.field_6011.method_12784(Q, (Object)QuaternionF.ONE);
        this.field_6011.method_12784(THROTTLE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(AFTERBURNER, (Object)false);
        this.field_6011.method_12784(HIDE_MODEL, (Object)false);
        this.field_6011.method_12784(ALTITUDE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(INPUTS, (Object)class_243.field_1353);
        this.field_6011.method_12784(OVERRIDES, (Object)new class_2487());
        this.field_6011.method_12784(PRESET, (Object)"wooden_plane");
    }

    public void method_5674(@NotNull class_2940<?> key) {
        String sync;
        if (key.equals(PRESET) && !(sync = (String)this.field_6011.method_12789(PRESET)).equals(this.getStatsId())) {
            this.setPreset(sync);
        }
    }

    public void setPreset(@NotNull String preset) {
        super.setPreset(preset);
        this.field_6011.method_12778(PRESET, (Object)preset);
    }

    @NotNull
    public JsonPresetReloadListener<VehicleStats> getPresets() {
        return VehiclePresets.get();
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.verifyCurrentPresetId();
        this.field_6011.method_12778(PRESET, (Object)this.getStatsId());
        this.setSpeed(UtilParse.readVec3((class_2487)tag, (String)"speed"));
        float qi = tag.method_10583("qi");
        float qj = tag.method_10583("qj");
        float qk = tag.method_10583("qk");
        float qr = tag.method_10583("qr");
        this.setQ(new QuaternionF(qi, qj, qk, qr));
        this.setThrottle(tag.method_10583("throttle"));
        this.setAfterBurner(tag.method_10577("afterburner"));
        this.setHideModel(tag.method_10577("hide_model"));
        this.setAltitude(tag.method_10583("altitude"));
        this.setInputs(UtilParse.readVec3((class_2487)tag, (String)"inputs"));
        this.field_6011.method_12778(OVERRIDES, (Object)tag.method_10562("overrides"));
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        UtilParse.writeVec3((class_2487)tag, (class_243)this.getSpeed(), (String)"speed");
        QuaternionF q = this.getQ();
        tag.method_10548("qi", q.i());
        tag.method_10548("qj", q.j());
        tag.method_10548("qk", q.k());
        tag.method_10548("qr", q.r());
        tag.method_10548("throttle", this.getThrottle());
        tag.method_10556("afterburner", this.getAfterBurner());
        tag.method_10556("hide_model", this.getHideModel());
        tag.method_10548("altitude", this.getAltitude());
        UtilParse.writeVec3((class_2487)tag, (class_243)this.getInputs(), (String)"inputs");
        tag.method_10566("overrides", (class_2520)this.field_6011.method_12789(OVERRIDES));
    }

    public class_243 getSpeed() {
        return (class_243)this.field_6011.method_12789(SPEED);
    }

    public void setSpeed(class_243 speed) {
        this.field_6011.method_12778(SPEED, (Object)speed);
    }

    public QuaternionF getQ() {
        return (QuaternionF)this.field_6011.method_12789(Q);
    }

    public void setQ(QuaternionF q) {
        this.field_6011.method_12778(Q, (Object)q);
    }

    public float getThrottle() {
        return ((Float)this.field_6011.method_12789(THROTTLE)).floatValue();
    }

    public void setThrottle(float throttle) {
        this.field_6011.method_12778(THROTTLE, (Object)Float.valueOf(throttle));
    }

    public boolean getAfterBurner() {
        return (Boolean)this.field_6011.method_12789(AFTERBURNER);
    }

    public void setAfterBurner(boolean enable) {
        this.field_6011.method_12778(AFTERBURNER, (Object)enable);
    }

    public boolean getHideModel() {
        return (Boolean)this.field_6011.method_12789(HIDE_MODEL);
    }

    public void setHideModel(boolean enable) {
        this.field_6011.method_12778(HIDE_MODEL, (Object)enable);
    }

    public float getAltitude() {
        return ((Float)this.field_6011.method_12789(ALTITUDE)).floatValue();
    }

    public void setAltitude(float alt) {
        this.field_6011.method_12778(ALTITUDE, (Object)Float.valueOf(alt));
    }

    public class_243 getInputs() {
        return (class_243)this.field_6011.method_12789(INPUTS);
    }

    public void setInputs(class_243 inputs) {
        this.field_6011.method_12778(INPUTS, (Object)inputs);
    }
}

