/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.AntiRadarMissileStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.server.MinecraftServer;

public class AntiRadarMissile<T extends AntiRadarMissileStats>
extends EntityMissile<T> {
    protected List<ARTarget> targets = new ArrayList<ARTarget>();

    public AntiRadarMissile(class_1299<? extends AntiRadarMissile<?>> type, class_1937 level, String defaultWeaponId) {
        super((class_1299<? extends EntityMissile<?>>)type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.ANTI_RADAR_MISSILE;
    }

    @Override
    public void tickGuide() {
        if (this.field_6012 % 10 == 0) {
            this.findARTarget();
        }
        if (this.target != null) {
            this.guideToTarget();
        }
    }

    @Override
    public boolean dieIfNoTargetOutsideTickRange() {
        return false;
    }

    protected void findARTarget() {
        this.targets.clear();
        MinecraftServer server = this.getWorld().method_8503();
        if (server == null) {
            return;
        }
        double rangeSqr = ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange() * ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange();
        List players = server.method_3760().method_14571();
        for (Object player : players) {
            this.checkEntity((class_1297)player, rangeSqr);
        }
        Collection<class_1297> entities = TrackableEntitiesManager.getTrackableEntities();
        for (class_1297 entity : entities) {
            this.checkEntity(entity, rangeSqr);
        }
        if (this.targets.isEmpty()) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        ARTarget max = this.targets.get(0);
        for (int i = 1; i < this.targets.size(); ++i) {
            if (!(this.targets.get((int)i).radiation > max.radiation)) continue;
            max = this.targets.get(i);
        }
        this.target = max.entity;
        this.targetPos = max.entity.method_19538();
    }

    protected void checkEntity(class_1297 entity, double rangeSqr) {
        EntityVehicle vehicle;
        if (entity.method_7325()) {
            return;
        }
        if (this.method_5858(entity) > rangeSqr) {
            return;
        }
        if (!UtilEntity.getLevel((class_1297)entity).method_27983().equals(this.getWorld().method_27983())) {
            return;
        }
        if (entity instanceof EntityVehicle) {
            EntityVehicle ev;
            vehicle = ev = (EntityVehicle)entity;
        } else {
            class_1297 class_12972 = entity.method_5668();
            if (class_12972 instanceof EntityVehicle) {
                EntityVehicle ev;
                vehicle = ev = (EntityVehicle)class_12972;
            } else {
                return;
            }
        }
        if (!vehicle.radarSystem.hasRadar()) {
            return;
        }
        if (vehicle.getRadarMode().isOff()) {
            return;
        }
        if (!vehicle.radarSystem.canServerTick()) {
            return;
        }
        if (!this.basicCheck((class_1297)vehicle)) {
            return;
        }
        float distSqr = (float)this.method_5858((class_1297)vehicle);
        this.targets.add(new ARTarget((class_1297)vehicle, (float)vehicle.radarSystem.getMaxAirRange() / distSqr));
    }

    protected boolean basicCheck(class_1297 ping) {
        if (!ping.method_24828()) {
            return false;
        }
        if (this.method_5722(ping)) {
            return false;
        }
        if (!this.checkTargetRange(ping, ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange())) {
            return false;
        }
        return this.checkCanSee(ping);
    }

    public static class ARTarget {
        public final class_1297 entity;
        public final float radiation;

        public ARTarget(class_1297 entity, float radiation) {
            this.entity = entity;
            this.radiation = radiation;
        }
    }
}

