/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.IRMissileStats;
import com.onewhohears.dscombat.entity.IREmitter;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public class IRMissile<T extends IRMissileStats>
extends EntityMissile<T> {
    protected List<IrTarget> targets = new ArrayList<IrTarget>();
    public static final double IR_RANGE = 300.0;

    public IRMissile(class_1299<? extends IRMissile<?>> type, class_1937 level, String defaultWeaponId) {
        super((class_1299<? extends EntityMissile<?>>)type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.IR_MISSILE;
    }

    @Override
    public void tickGuide() {
        if (this.field_6012 % 10 == 0) {
            this.findIrTarget();
        }
        if (this.target != null) {
            this.guideToTarget();
        }
    }

    public static void updateIRTargetsList(class_1297 weapon, List<IrTarget> targets, float flareResistance, float fov) {
        targets.clear();
        List irEmitters = UtilEntity.getLevel((class_1297)weapon).method_8333(weapon, IRMissile.getIrBoundingBox(weapon), entity -> entity.method_5864().method_20210(ModTags.EntityTypes.IR_EMITTER));
        for (class_1297 emitter : irEmitters) {
            if (emitter.method_5765() || !IRMissile.basicCheck(weapon, emitter, true, fov)) continue;
            float distSqr = (float)weapon.method_5858(emitter);
            float heat = IRMissile.getEntityHeat(emitter, flareResistance);
            targets.add(new IrTarget(emitter, heat / distSqr));
        }
    }

    public static float getEntityHeat(class_1297 entity, float flareResistance) {
        float heat = 0.0f;
        if (entity instanceof IREmitter) {
            IREmitter ir = (IREmitter)entity;
            heat = ir.getIRHeat();
        } else if (entity.method_5864().method_20210(ModTags.EntityTypes.IR_EMITTER_EXTREME)) {
            heat = 100.0f;
        } else if (entity.method_5864().method_20210(ModTags.EntityTypes.IR_EMITTER_HIGH)) {
            heat = 20.0f;
        } else if (entity.method_5864().method_20210(ModTags.EntityTypes.IR_EMITTER_MED)) {
            heat = 5.0f;
        } else if (entity.method_5864().method_20210(ModTags.EntityTypes.IR_EMITTER_LOW)) {
            heat = 1.0f;
        }
        if (entity.method_5864().method_20210(ModTags.EntityTypes.FLARE)) {
            heat *= flareResistance;
        }
        return heat;
    }

    protected void findIrTarget() {
        IRMissile.updateIRTargetsList((class_1297)this, this.targets, ((IRMissileStats)((Object)this.getWeaponStats())).getFlareResistance(), ((IRMissileStats)((Object)this.getWeaponStats())).getFov());
        if (this.targets.isEmpty()) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        IrTarget max = this.targets.get(0);
        for (int i = 1; i < this.targets.size(); ++i) {
            if (!(this.targets.get((int)i).heat > max.heat)) continue;
            max = this.targets.get(i);
        }
        this.target = max.entity;
        this.targetPos = max.entity.method_19538();
    }

    protected static boolean basicCheck(class_1297 weapon, class_1297 ping, boolean checkGround, float fov) {
        if (weapon.equals((Object)ping)) {
            return false;
        }
        if (ping.method_7325()) {
            return false;
        }
        if (checkGround && ping.method_24828()) {
            return false;
        }
        if (ping.method_5799()) {
            return false;
        }
        if (weapon.method_5722(ping)) {
            return false;
        }
        if (!IRMissile.checkTargetRange(weapon, ping, fov, 300.0)) {
            return false;
        }
        return UtilEntity.canEntitySeeEntity((class_1297)weapon, (class_1297)ping, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()), (double)0.0, (double)0.0);
    }

    public static class_238 getIrBoundingBox(class_1297 e) {
        double x = e.method_23317();
        double y = e.method_23318();
        double z = e.method_23321();
        double w = 300.0;
        return new class_238(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.IR_MISSILE.getSource(this.method_24921(), this);
    }

    public static class IrTarget {
        public final class_1297 entity;
        public final float heat;

        public IrTarget(class_1297 entity, float heat) {
            this.entity = entity;
            this.heat = heat;
        }
    }
}

