/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.radar.RadarPresets;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.item.ItemPart;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class UtilPresetParse {
    @Nullable
    public static PartStats getPartStatsFromItem(class_1799 stack) {
        if (stack.method_7985()) {
            return UtilPresetParse.getPartStatsFromCompound(stack.method_7969());
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ItemPart)) {
            return null;
        }
        ItemPart part = (ItemPart)class_17922;
        return part.getDefaultPartStats();
    }

    @Nullable
    public static PartStats getPartStatsFromCompound(class_2487 tag) {
        if (tag == null) {
            return null;
        }
        if (tag.method_33133()) {
            return null;
        }
        String presetId = "";
        if (tag.method_10545("part")) {
            presetId = tag.method_10558("part");
        } else if (tag.method_10545("presetId")) {
            presetId = tag.method_10558("presetId");
        } else if (tag.method_10545("itemid")) {
            presetId = tag.method_10558("itemid");
            presetId = presetId.split(":")[1];
        }
        if (presetId.isEmpty()) {
            return null;
        }
        return (PartStats)PartPresets.get().get(presetId);
    }

    @Nullable
    public static PartInstance<?> parsePartFromItem(class_1799 stack, String defaultPartPresetId) {
        if (stack.method_7985()) {
            return UtilPresetParse.parsePartFromCompound(stack.method_7969());
        }
        PartStats stats = (PartStats)PartPresets.get().get(defaultPartPresetId);
        if (stats == null) {
            return null;
        }
        return stats.createPartInstance();
    }

    @Nullable
    public static PartInstance<?> parsePartFromItem(class_1799 stack) {
        if (stack.method_7985()) {
            return UtilPresetParse.parsePartFromCompound(stack.method_7969());
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ItemPart)) {
            return null;
        }
        ItemPart part = (ItemPart)class_17922;
        String presetId = part.getDefaultPartPresetId();
        PartStats stats = (PartStats)PartPresets.get().get(presetId);
        if (stats == null) {
            return null;
        }
        return stats.createPartInstance();
    }

    @Nullable
    public static PartInstance<?> parsePartFromCompound(class_2487 tag) {
        boolean old;
        PartStats stats = UtilPresetParse.getPartStatsFromCompound(tag);
        if (stats == null) {
            return null;
        }
        if (tag.method_10577("filled")) {
            return stats.createFilledPartInstance(tag.method_10558("param"));
        }
        PartInstance<?> data = stats.createPartInstance();
        boolean bl = old = tag.method_10550("parse_version") < 2;
        if (old || tag.method_10577("readnbt")) {
            data.readNBT(tag);
        }
        if (tag.method_10545("param")) {
            data.setParamNotFilled(tag.method_10558("param"));
        }
        return data;
    }

    @Nullable
    public static WeaponInstance<?> parseWeaponFromCompound(class_2487 tag) {
        return (WeaponInstance)WeaponPresets.get().createInstanceFromNbt(tag);
    }

    @Nullable
    public static RadarStats parseRadarFromCompound(class_2487 tag) {
        return RadarPresets.get().getFromNbt(tag);
    }
}

