/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.mojang.authlib.GameProfile;
import com.onewhohears.dscombat.data.vehicle.physics.SeaLevels;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.DSCFakePlayer;
import com.onewhohears.dscombat.util.fabric.UtilVehicleEntityImpl;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilVehicleEntity {
    private static final IntValue XP = new IntValue(){

        public void accept(int value) {
        }

        public int getAsInt() {
            return 0;
        }
    };
    public static final int WIND_TUNNEL_SEARCH_RANGE = 16;

    public static double getRadarCrossSectionalArea(class_1297 entity, class_243 radarPos) {
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            return plane.getRadarArea(radarPos);
        }
        double area = entity.method_17682() * entity.method_17681();
        if (entity.method_5864().method_20210(ModTags.EntityTypes.VEHICLE)) {
            return Math.max(area, 1.0);
        }
        return area;
    }

    public static boolean isOnGroundOrWater(class_1297 entity) {
        class_1657 p;
        if (entity.method_5864().method_20210(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
            return true;
        }
        if (entity.method_5765()) {
            class_1297 rv = entity.method_5668();
            if (rv.method_5864().method_20210(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
                return true;
            }
            if (rv.method_24828() || UtilEntity.isHeadAboveWater((class_1297)rv)) {
                return true;
            }
        }
        if (entity instanceof class_1657 && (p = (class_1657)entity).method_6128()) {
            return false;
        }
        if (!entity.method_5799() && entity.method_5624() && (double)entity.field_6017 < 1.15) {
            return true;
        }
        return entity.method_24828() || UtilEntity.isHeadAboveWater((class_1297)entity);
    }

    public static double getAirDensity(class_1297 entity) {
        return SeaLevels.getAirPressure((class_5321<class_1937>)UtilEntity.getLevel((class_1297)entity).method_27983(), entity.method_23318());
    }

    public static boolean hasPermissionToBreakBlock(class_2338 pos, class_2680 state, class_1937 level, @Nullable class_1297 entity, DSCFakePlayer type) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            EventResult result = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, state, player, XP);
            return !result.isPresent() || result.isTrue();
        }
        if (entity instanceof class_1569) {
            return level.method_8450().method_8355(class_1928.field_19388);
        }
        if (!level.method_8608()) {
            EventResult result = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, state, type.getPlayer((class_3218)level), XP);
            return !result.isPresent() || result.isTrue();
        }
        return false;
    }

    public static boolean vehicleHasPermissionToTrample(class_2338 pos, class_2680 state, class_1937 level, @Nullable class_1297 entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.VEHICLE_TRAMPLE);
    }

    public static boolean weaponHasPermissionToBreak(class_2338 pos, class_2680 state, class_1937 level, @Nullable class_1297 entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.WEAPON_BREAK);
    }

    public static Optional<EntityWindTunnel> findWindTunnel(class_243 pos, class_1937 level) {
        double r = 16.0;
        List tunnels = level.method_18467(EntityWindTunnel.class, new class_238(pos.field_1352 - r, pos.field_1351 - r, pos.field_1350 - r, pos.field_1352 + r, pos.field_1351 + r, pos.field_1350 + r));
        if (tunnels.isEmpty()) {
            return Optional.empty();
        }
        return tunnels.stream().min((tunnel1, tunnel2) -> (int)(tunnel2.method_5707(pos) - tunnel1.method_5707(pos)));
    }

    public static int getDistFromGround(class_1297 entity, int limit, boolean ignoreWater) {
        class_2680 block;
        int dist;
        class_1937 l = UtilEntity.getLevel((class_1297)entity);
        int[] pos = new int[]{entity.method_31477(), entity.method_31478(), entity.method_31479()};
        for (dist = 0; pos[1] >= l.method_31607() && dist <= limit && ((block = l.method_8320(new class_2338(pos[0], pos[1], pos[2]))) == null || block.method_26215() || ignoreWater && !UtilEntity.blocksMotion((class_2680)block)); ++dist) {
            pos[1] = pos[1] - 1;
        }
        return dist;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_3222 createFakePlayer(class_3218 level, GameProfile profile) {
        void var1_1;
        return UtilVehicleEntityImpl.createFakePlayer(level, (GameProfile)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void revive(class_1297 entity) {
        UtilVehicleEntityImpl.revive(entity);
    }

    public static boolean isExplosion(@NotNull class_1282 source) {
        return source.method_48789(class_8103.field_42249);
    }

    public static boolean isFire(@NotNull class_1282 source) {
        return source.method_48789(class_8103.field_42246);
    }

    public static boolean isBypassArmor(@NotNull class_1282 source) {
        return source.method_48789(class_8103.field_42241);
    }

    public static boolean isProjectile(@NotNull class_1282 source) {
        return source.method_48789(class_8103.field_42247);
    }
}

