/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.crafting;

import com.onewhohears.onewholibs.data.crafting.fabric.IngredientStackImpl;
import com.onewhohears.onewholibs.util.UtilItem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IngredientStack
extends class_1856 {
    public final int cost;

    public static IngredientStack fromItem(String itemId, int cost) {
        return new IngredientStack((class_1856.class_1859)new class_1856.class_1857(UtilItem.getItem(itemId).method_7854()), cost);
    }

    public static IngredientStack fromItem(class_1799 item, int cost) {
        return new IngredientStack((class_1856.class_1859)new class_1856.class_1857(item), cost);
    }

    public static IngredientStack fromTag(String tagId, int cost) {
        return new IngredientStack((class_1856.class_1859)new class_1856.class_1858(IngredientStack.createItemTag(tagId)), cost);
    }

    public static class_6862<class_1792> createItemTag(String id) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)id));
    }

    public static IngredientStack fromIngredient(class_1856 ingredient) {
        class_1856.class_1859[] values = new class_1856.class_1859[ingredient.method_8105().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new class_1856.class_1857(ingredient.method_8105()[i]);
        }
        return new IngredientStack(Stream.of(values), 1);
    }

    @NotNull
    public static IngredientStack fromNetwork(class_2540 buffer) {
        Stream<class_1856.class_1859> stream = buffer.method_34066(class_2540::method_10819).stream().map(class_1856.class_1857::new);
        int cost = buffer.readInt();
        return new IngredientStack(stream, cost);
    }

    public static void toNetwork(class_2540 buffer, class_1856 ingredient) {
        IngredientStack.dissolve(ingredient);
        buffer.method_34062(Arrays.asList(ingredient.field_9018), class_2540::method_10793);
        if (ingredient instanceof IngredientStack) {
            IngredientStack stack = (IngredientStack)ingredient;
            buffer.writeInt(stack.cost);
        } else {
            buffer.writeInt(1);
        }
    }

    protected IngredientStack(class_1856.class_1859 value, int cost) {
        this(Stream.of(value), cost);
    }

    protected IngredientStack(Stream<class_1856.class_1859> values, int cost) {
        super(values);
        this.cost = cost;
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        if (stack == null) {
            return false;
        }
        class_1799[] items = this.method_8105();
        if (items.length == 0) {
            return stack.method_7960();
        }
        for (class_1799 itemstack : items) {
            if (!itemstack.method_31574(stack.method_7909()) || stack.method_7947() < this.cost) continue;
            return true;
        }
        return false;
    }

    public class_1799 @NotNull [] method_8105() {
        class_1799[] items;
        for (class_1799 item : items = super.method_8105()) {
            item.method_7939(this.cost);
        }
        return items;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void dissolve(class_1856 ingredient) {
        IngredientStackImpl.dissolve(ingredient);
    }
}

