/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class JsonPresetGenerator<T extends JsonPresetStats>
implements class_2405 {
    protected final Logger LOGGER = LogUtils.getLogger();
    protected final class_7784.class_7489 pathProvider;
    public final Map<class_2960, T> GEN_MAP = new HashMap<class_2960, T>();

    public JsonPresetGenerator(class_7784 output, String kind) {
        this(output, kind, class_7784.class_7490.field_39367);
    }

    public JsonPresetGenerator(class_7784 output, String kind, class_7784.class_7490 target) {
        this.pathProvider = output.method_45973(target, kind);
    }

    protected abstract void registerPresets();

    @NotNull
    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.GEN_MAP.clear();
        this.registerPresets();
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        Consumer<JsonPresetStats> consumer = preset -> {
            this.LOGGER.debug("GENERATING: {}", (Object)preset.getKey().toString());
            if (!set.add(preset.getKey())) {
                throw new IllegalStateException("Duplicate Preset! " + String.valueOf(preset.getKey()));
            }
            Path path = this.pathProvider.method_44107(preset.getKey());
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)preset.getJsonData(), (Path)path));
        };
        this.generatePresets(consumer);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void generatePresets(Consumer<T> consumer) {
        this.GEN_MAP.forEach((key, preset) -> consumer.accept(preset));
    }

    public void addPresetToGenerate(T preset) {
        this.GEN_MAP.put(((JsonPresetStats)preset).getKey(), preset);
    }
}

