/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.class_2960;

public abstract class PresetBuilder<C extends PresetBuilder<C>> {
    private final String name;
    private final class_2960 key;
    private final JsonObject data;
    protected final JsonPresetType type;
    private final String copyId;
    private final JsonObject copyData;

    public PresetBuilder(String namespace, String name, JsonPresetType type) {
        this.name = name;
        this.key = new class_2960(namespace, name);
        this.data = new JsonObject();
        this.data.addProperty("presetType", type.getId());
        this.data.addProperty("presetId", name);
        this.data.addProperty("displayName", "preset." + namespace + "." + name);
        this.type = type;
        this.copyId = "";
        this.copyData = new JsonObject();
        this.setupJsonData();
    }

    public PresetBuilder(String namespace, String name, JsonPresetType type, JsonObject copy) {
        this.name = name;
        this.key = new class_2960(namespace, name);
        this.data = new JsonObject();
        this.data.addProperty("presetType", type.getId());
        this.data.addProperty("presetId", name);
        this.data.addProperty("displayName", "preset." + namespace + "." + name);
        this.type = type;
        this.copyId = copy.get("presetId").getAsString();
        this.copyData = copy;
        this.data.addProperty("copyId", this.copyId);
        this.setupJsonData();
    }

    public <T extends JsonPresetStats> T build() {
        return this.type.createStats(this.key, this.getData());
    }

    protected void setupJsonData() {
    }

    public String getPresetId() {
        return this.name;
    }

    public class_2960 getKey() {
        return this.key;
    }

    public JsonObject getData() {
        return this.data;
    }

    public boolean isCopy() {
        return !this.copyId.isEmpty();
    }

    public String getCopyId() {
        return this.copyId;
    }

    public JsonObject getCopyData() {
        return this.copyData;
    }

    public C setSortFactor(int sort_factor) {
        return this.setInt("sort_factor", sort_factor);
    }

    public C setDisplayName(String name) {
        return this.setString("displayName", name);
    }

    public C setBoolean(String key, boolean value) {
        this.data.addProperty(key, Boolean.valueOf(value));
        return (C)this;
    }

    public C setInt(String key, int value) {
        this.data.addProperty(key, (Number)value);
        return (C)this;
    }

    public C setFloat(String key, float value) {
        this.data.addProperty(key, (Number)Float.valueOf(value));
        return (C)this;
    }

    public C setString(String key, String value) {
        this.data.addProperty(key, value);
        return (C)this;
    }

    public C setEnum(String key, Enum<?> value) {
        this.data.addProperty(key, value.name());
        return (C)this;
    }
}

