/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.entity;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.PresetNotFoundException;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import com.onewhohears.onewholibs.entity.AdditionalSpawnDataEntity;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public interface JsonPresetEntityHolder<P extends JsonPresetStats>
extends AdditionalSpawnDataEntity {
    public static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public JsonPresetReloadListener<P> getPresets();

    @NotNull
    public String getDefaultStatsId();

    @NotNull
    public String getStatsId();

    @NotNull
    public PresetStatsHolder<P> getStatsHolder();

    @NotNull
    default public PresetStatsHolder<P> createStatsHolder(@NotNull String presetId) {
        return Objects.requireNonNull(this.getPresets().getHolder(presetId));
    }

    default public void updateStatsHolder(@NotNull String presetId) {
        PresetStatsHolder<P> holder = this.createStatsHolder(presetId);
        this.setStatsHolder(holder);
    }

    @NotNull
    default public P getStats() {
        return this.getStatsHolder().get();
    }

    default public void setPreset(@NotNull String preset) {
        if (!this.getPresets().has(preset)) {
            LOGGER.warn("Preset id {} does not exist. Using default id {}", (Object)preset, (Object)this.getDefaultStatsId());
            preset = this.getDefaultStatsId();
            if (!this.getPresets().has(preset)) {
                throw new PresetNotFoundException(preset, this.getPresets());
            }
        }
        if (this.isStatsHolderLoaded() && this.getStatsId().equals(preset)) {
            return;
        }
        this.setStatsId(preset);
        this.updateStatsHolder(preset);
    }

    public void setStatsId(@NotNull String var1);

    public void setStatsHolder(@NotNull PresetStatsHolder<P> var1);

    default public void method_5749(@NotNull class_2487 nbt) {
        String preset = nbt.method_10558("preset");
        if (preset.isEmpty()) {
            preset = this.getDefaultStatsId();
        } else if (!this.getPresets().has(preset)) {
            LOGGER.warn("ERROR: preset {} doesn't exist!", (Object)preset);
            preset = this.getDefaultStatsId();
        }
        this.setStatsId(preset);
        this.updateStatsHolder(this.getStatsId());
    }

    default public void method_5652(@NotNull class_2487 nbt) {
        nbt.method_10582("preset", this.getStatsId());
    }

    @Override
    default public void readSpawnData(class_2540 buffer) {
        this.setStatsId(buffer.method_19772());
        this.updateStatsHolder(this.getStatsId());
    }

    @Override
    default public void writeSpawnData(class_2540 buffer) {
        buffer.method_10814(this.getStatsId());
    }

    public boolean isStatsHolderLoaded();

    public boolean isClientSide();

    public int getId();
}

