/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.class_3532;
import org.joml.Quaternionf;

public final class QuaternionF {
    public static final QuaternionF ONE = new QuaternionF(0.0f, 0.0f, 0.0f, 1.0f);
    private float i;
    private float j;
    private float k;
    private float r;

    public QuaternionF(float f, float g, float h, float i) {
        this.i = f;
        this.j = g;
        this.k = h;
        this.r = i;
    }

    public QuaternionF(Vec3f vec3f, float f, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
        }
        float g = QuaternionF.sin(f / 2.0f);
        this.i = vec3f.x() * g;
        this.j = vec3f.y() * g;
        this.k = vec3f.z() * g;
        this.r = QuaternionF.cos(f / 2.0f);
    }

    public QuaternionF(float f, float g, float h, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
            g *= (float)Math.PI / 180;
            h *= (float)Math.PI / 180;
        }
        float i = QuaternionF.sin(0.5f * f);
        float j = QuaternionF.cos(0.5f * f);
        float k = QuaternionF.sin(0.5f * g);
        float l = QuaternionF.cos(0.5f * g);
        float m = QuaternionF.sin(0.5f * h);
        float n = QuaternionF.cos(0.5f * h);
        this.i = i * l * n + j * k * m;
        this.j = j * k * n - i * l * m;
        this.k = i * k * n + j * l * m;
        this.r = j * l * n - i * k * m;
    }

    public QuaternionF(QuaternionF QuaternionF2) {
        this.i = QuaternionF2.i;
        this.j = QuaternionF2.j;
        this.k = QuaternionF2.k;
        this.r = QuaternionF2.r;
    }

    public static QuaternionF fromYXZ(float f, float g, float h) {
        QuaternionF QuaternionF2 = ONE.copy();
        QuaternionF2.mul(new QuaternionF(0.0f, (float)Math.sin(f / 2.0f), 0.0f, (float)Math.cos(f / 2.0f)));
        QuaternionF2.mul(new QuaternionF((float)Math.sin(g / 2.0f), 0.0f, 0.0f, (float)Math.cos(g / 2.0f)));
        QuaternionF2.mul(new QuaternionF(0.0f, 0.0f, (float)Math.sin(h / 2.0f), (float)Math.cos(h / 2.0f)));
        return QuaternionF2;
    }

    public static QuaternionF fromXYZDegrees(Vec3f vec3f) {
        return QuaternionF.fromXYZ((float)Math.toRadians(vec3f.x()), (float)Math.toRadians(vec3f.y()), (float)Math.toRadians(vec3f.z()));
    }

    public static QuaternionF fromXYZ(Vec3f vec3f) {
        return QuaternionF.fromXYZ(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public static QuaternionF fromXYZ(float f, float g, float h) {
        QuaternionF QuaternionF2 = ONE.copy();
        QuaternionF2.mul(new QuaternionF((float)Math.sin(f / 2.0f), 0.0f, 0.0f, (float)Math.cos(f / 2.0f)));
        QuaternionF2.mul(new QuaternionF(0.0f, (float)Math.sin(g / 2.0f), 0.0f, (float)Math.cos(g / 2.0f)));
        QuaternionF2.mul(new QuaternionF(0.0f, 0.0f, (float)Math.sin(h / 2.0f), (float)Math.cos(h / 2.0f)));
        return QuaternionF2;
    }

    public Vec3f toXYZ() {
        float f = this.r() * this.r();
        float g = this.i() * this.i();
        float h = this.j() * this.j();
        float i = this.k() * this.k();
        float j = f + g + h + i;
        float k = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float l = (float)Math.asin(k / j);
        return Math.abs(k) > 0.999f * j ? new Vec3f(2.0f * (float)Math.atan2(this.i(), this.r()), l, 0.0f) : new Vec3f((float)Math.atan2(2.0f * this.j() * this.k() + 2.0f * this.i() * this.r(), f - g - h + i), l, (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), f + g - h - i));
    }

    public Vec3f toXYZDegrees() {
        Vec3f vec3f = this.toXYZ();
        return new Vec3f((float)Math.toDegrees(vec3f.x()), (float)Math.toDegrees(vec3f.y()), (float)Math.toDegrees(vec3f.z()));
    }

    public Vec3f toYXZ() {
        float f = this.r() * this.r();
        float g = this.i() * this.i();
        float h = this.j() * this.j();
        float i = this.k() * this.k();
        float j = f + g + h + i;
        float k = 2.0f * this.r() * this.i() - 2.0f * this.j() * this.k();
        float l = (float)Math.asin(k / j);
        return Math.abs(k) > 0.999f * j ? new Vec3f(l, 2.0f * (float)Math.atan2(this.j(), this.r()), 0.0f) : new Vec3f(l, (float)Math.atan2(2.0f * this.i() * this.k() + 2.0f * this.j() * this.r(), f - g - h + i), (float)Math.atan2(2.0f * this.i() * this.j() + 2.0f * this.r() * this.k(), f - g + h - i));
    }

    public Vec3f toYXZDegrees() {
        Vec3f vec3f = this.toYXZ();
        return new Vec3f((float)Math.toDegrees(vec3f.x()), (float)Math.toDegrees(vec3f.y()), (float)Math.toDegrees(vec3f.z()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            QuaternionF QuaternionF2 = (QuaternionF)object;
            if (Float.compare(QuaternionF2.i, this.i) != 0) {
                return false;
            }
            if (Float.compare(QuaternionF2.j, this.j) != 0) {
                return false;
            }
            if (Float.compare(QuaternionF2.k, this.k) != 0) {
                return false;
            }
            return Float.compare(QuaternionF2.r, this.r) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.i);
        i = 31 * i + Float.floatToIntBits(this.j);
        i = 31 * i + Float.floatToIntBits(this.k);
        i = 31 * i + Float.floatToIntBits(this.r);
        return i;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("QuaternionF[").append(this.r()).append(" + ");
        stringBuilder.append(this.i()).append("i + ");
        stringBuilder.append(this.j()).append("j + ");
        stringBuilder.append(this.k()).append("k]");
        return stringBuilder.toString();
    }

    public float i() {
        return this.i;
    }

    public float j() {
        return this.j;
    }

    public float k() {
        return this.k;
    }

    public float r() {
        return this.r;
    }

    public void mul(QuaternionF QuaternionF2) {
        float f = this.i();
        float g = this.j();
        float h = this.k();
        float i = this.r();
        float j = QuaternionF2.i();
        float k = QuaternionF2.j();
        float l = QuaternionF2.k();
        float m = QuaternionF2.r();
        this.i = i * j + f * m + g * l - h * k;
        this.j = i * k - f * l + g * m + h * j;
        this.k = i * l + f * k - g * j + h * m;
        this.r = i * m - f * j - g * k - h * l;
    }

    public void mul(float f) {
        this.i *= f;
        this.j *= f;
        this.k *= f;
        this.r *= f;
    }

    public void conj() {
        this.i = -this.i;
        this.j = -this.j;
        this.k = -this.k;
    }

    public void set(float f, float g, float h, float i) {
        this.i = f;
        this.j = g;
        this.k = h;
        this.r = i;
    }

    private static float cos(float f) {
        return (float)Math.cos(f);
    }

    private static float sin(float f) {
        return (float)Math.sin(f);
    }

    public void normalize() {
        float f = this.i() * this.i() + this.j() * this.j() + this.k() * this.k() + this.r() * this.r();
        if (f > 1.0E-6f) {
            float g = (float)class_3532.method_15345((double)f);
            this.i *= g;
            this.j *= g;
            this.k *= g;
            this.r *= g;
        } else {
            this.i = 0.0f;
            this.j = 0.0f;
            this.k = 0.0f;
            this.r = 0.0f;
        }
    }

    public void slerp(QuaternionF QuaternionF2, float f) {
        throw new UnsupportedOperationException();
    }

    public QuaternionF copy() {
        return new QuaternionF(this);
    }

    public Quaternionf convert() {
        return new Quaternionf(this.i, this.j, this.k, this.r);
    }

    public static QuaternionF from(Quaternionf q) {
        return new QuaternionF(q.x(), q.y(), q.z(), q.w());
    }
}

