/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ObjEntityModel<T extends Entity> {
    public static final Mat4f INVISIBLE = Mat4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
    public final String modelId;
    private final Map<String, Mat4f> transforms = new HashMap<String, Mat4f>();
    private ObjEntityModels.ModelOverrides modelOverride;
    private ObjModelHandler modelHandler;

    public ObjEntityModel(String modelId) {
        this.modelId = modelId;
    }

    public void render(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        this.rotate(entity, partialTicks, poseStack);
        this.handleGlobalOverrides(entity, partialTicks, poseStack);
        this.transforms.clear();
        this.addComponentTransforms(this.transforms, entity, partialTicks);
        this.getObjModelHandler().render(poseStack, bufferSource, partialTicks, this.getLight(entity, lightmap), this.getOverlay(entity), this.transforms, this.getTextureRenderTypeLookup(entity));
    }

    protected ObjModelHandler getObjModelHandler() {
        if (this.modelHandler == null) {
            this.modelHandler = ObjEntityModels.get().getObjModelHandler(this.modelId);
        }
        return this.modelHandler;
    }

    protected void rotate(T entity, float partialTicks, PoseStack poseStack) {
        Vec3f pivot = this.getGlobalPivot();
        QuaternionF yRot = Vec3f.YN.rotationDegrees(entity.m_5675_(partialTicks));
        QuaternionF xRot = Vec3f.XP.rotationDegrees(entity.m_5686_(partialTicks));
        if (!UtilGeometry.isZero(pivot)) {
            if (this.globalRotateY()) {
                poseStack.m_166854_(UtilAngles.pivotInvRot(pivot, yRot).convert());
            }
            if (this.globalRotateX()) {
                poseStack.m_166854_(UtilAngles.pivotInvRot(pivot, xRot).convert());
            }
        } else {
            if (this.globalRotateY()) {
                poseStack.m_85845_(yRot.convert());
            }
            if (this.globalRotateX()) {
                poseStack.m_85845_(xRot.convert());
            }
        }
    }

    protected void handleGlobalOverrides(T entity, float partialTicks, PoseStack poseStack) {
        Vec3f pivot = this.getGlobalPivot();
        if (!UtilGeometry.isZero(pivot)) {
            poseStack.m_85837_((double)pivot.x(), (double)pivot.y(), (double)pivot.z());
        }
        this.getModelOverride().applyNoTranslate(poseStack);
    }

    public ObjEntityModels.ModelOverrides getModelOverride() {
        if (this.modelOverride == null) {
            this.modelOverride = ObjEntityModels.get().getModelOverride(this.modelId);
        }
        return this.modelOverride;
    }

    protected void addComponentTransforms(Map<String, Mat4f> transforms, T entity, float partialTicks) {
    }

    protected Function<ResourceLocation, RenderType> getTextureRenderTypeLookup(T entity) {
        return RenderType::m_110473_;
    }

    protected int getLight(T entity, int lightmap) {
        return lightmap;
    }

    protected int getOverlay(T entity) {
        return OverlayTexture.f_118083_;
    }

    public Vec3f getGlobalPivot() {
        return this.getModelOverride().translate;
    }

    public boolean globalRotateX() {
        return true;
    }

    public boolean globalRotateY() {
        return true;
    }
}

