/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.google.common.collect.ImmutableBiMap;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandlerImpl;
import com.onewhohears.onewholibs.client.model.obj.ObjUnbakedModel;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Mtl;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.MtlReader;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.Obj;
import com.onewhohears.onewholibs.shadow.de.javagl.obj.ObjReader;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ObjEntityModelsImpl
extends ObjEntityModels {
    private final Map<String, ObjUnbakedModel> unbakedModels = new HashMap<String, ObjUnbakedModel>();
    private final Map<String, ObjBakedModel> models = new HashMap<String, ObjBakedModel>();

    protected ObjEntityModelsImpl() {
    }

    @Override
    public ObjModelHandler createObjModelHandler(String id) {
        return new ObjModelHandlerImpl(id, this.getBakedModel(id), this.getUnbakedModel(id));
    }

    @Override
    public ObjUnbakedModel getUnbakedModel(String name) {
        if (!this.unbakedModels.containsKey(name)) {
            return this.unbakedModels.get("simple_test");
        }
        return this.unbakedModels.get(name);
    }

    @Override
    public ObjBakedModel getBakedModel(String name) {
        if (!this.models.containsKey(name)) {
            return this.models.get("simple_test");
        }
        return this.models.get(name);
    }

    @Override
    public boolean hasModel(String id) {
        return this.models.containsKey(id);
    }

    @Override
    public void bakeModels() {
        LOGGER.info("BAKING OBJ MODELS");
        this.models.clear();
        this.unbakedModels.forEach((key, obj) -> {
            try {
                ObjBakedModel bakedModel = obj.bake();
                this.models.put((String)key, bakedModel);
                LOGGER.info("BAKED {}", key);
            }
            catch (Exception e) {
                LOGGER.error("ERROR: OBJ BAKING FAILED {} because {}", key, (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @Override
    protected void setupObjModels(ResourceManager manager) {
        this.readUnbakedModels(manager);
        if (Platform.isFabric()) {
            this.bakeModels();
        }
    }

    public void readUnbakedModels(ResourceManager manager) {
        this.unbakedModels.clear();
        manager.m_214159_("models/entity", key -> key.m_135815_().endsWith(".obj")).forEach((key, resource) -> {
            try {
                ImmutableBiMap mtl;
                String name = new File(key.m_135815_()).getName().replace(".obj", "");
                if (this.unbakedModels.containsKey(name)) {
                    LOGGER.info("The model {} is overriding {}!", key, (Object)this.unbakedModels.get(name).getLocation());
                }
                Obj obj = ObjReader.read(ObjEntityModelsImpl.preprocessObj(resource.m_215508_()));
                Optional mtlRes = manager.m_213713_(ResourceLocation.m_214293_((String)key.m_135827_(), (String)("models/entity/" + name + ".mtl")));
                if (mtlRes.isPresent()) {
                    List<Mtl> mtlList = MtlReader.read(((Resource)mtlRes.get()).m_215508_());
                    mtlList.removeIf(m -> m.getMapKd() == null || m.getMapKd().equals("null"));
                    mtl = new ImmutableBiMap.Builder().putAll(mtlList.stream().collect(Collectors.toMap(Mtl::getName, m -> m, (a, b) -> a))).build();
                } else {
                    mtl = new ImmutableBiMap.Builder().build();
                }
                ObjUnbakedModel unbakedModel = new ObjUnbakedModel((ResourceLocation)key, obj, (Map<String, Mtl>)mtl);
                this.unbakedModels.put(name, unbakedModel);
                LOGGER.info("ADDING MODEL = {}", key);
            }
            catch (Exception e) {
                LOGGER.error("ERROR: OBJ PARSING FAILED {} because {}", key, (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public static Reader preprocessObj(BufferedReader reader) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> currentGroups = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.startsWith("g ")) {
                String[] groups = trimmed.substring(2).trim().split("\\s+");
                currentGroups.clear();
                currentGroups.addAll(Arrays.asList(groups));
                sb.append(line).append("\n");
                continue;
            }
            if (trimmed.startsWith("o ")) {
                String objName = trimmed.substring(2).trim();
                StringBuilder gLine = new StringBuilder("g ").append(objName);
                if (!currentGroups.isEmpty()) {
                    for (String g : currentGroups) {
                        gLine.append(" ").append(g);
                    }
                }
                sb.append((CharSequence)gLine).append("\n");
                continue;
            }
            sb.append(line).append("\n");
        }
        return new StringReader(sb.toString());
    }
}

