/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims;

import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransform;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CustomAnims {
    private static final Map<String, AnimationFactory> map = new HashMap<String, AnimationFactory>();

    public static void addAnim(String id, AnimationFactory animationFactory) {
        map.put(id, animationFactory);
    }

    @Nullable
    public static <T extends Entity> EntityModelTransform<T> get(JsonObject json) {
        String anim_id = UtilParse.getStringSafe(json, "anim_id", "");
        if (anim_id.isEmpty() || !map.containsKey(anim_id)) {
            return null;
        }
        return map.get(anim_id).create(json);
    }

    public static interface AnimationFactory<T extends Entity> {
        public EntityModelTransform<T> create(JsonObject var1);
    }
}

