/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.network.toclient;

import com.onewhohears.onewholibs.client.core.DistantRayCastManagerClient;
import com.onewhohears.onewholibs.common.core.RayCastPerspective;
import com.onewhohears.onewholibs.common.network.OWLPacketHandler;
import com.onewhohears.onewholibs.util.UtilPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ToClientCanSeePos
extends BaseS2CMessage {
    private final int rayCastId;
    private final RayCastPerspective perspective;
    private final int perspectiveEntityId;
    private final Vec3 targetPos;
    private final double throWater;
    private final double throBlock;

    public ToClientCanSeePos(int rayCastId, RayCastPerspective perspective, Entity perspectiveEntity, Vec3 targetPos, double throWater, double throBlock) {
        this.rayCastId = rayCastId;
        this.perspective = perspective;
        this.perspectiveEntityId = perspectiveEntity.m_19879_();
        this.targetPos = targetPos;
        this.throWater = throWater;
        this.throBlock = throBlock;
    }

    public ToClientCanSeePos(FriendlyByteBuf buffer) {
        this.rayCastId = buffer.readInt();
        this.perspective = (RayCastPerspective)buffer.m_130066_(RayCastPerspective.class);
        this.perspectiveEntityId = buffer.readInt();
        this.targetPos = UtilPacket.readVec3(buffer);
        this.throWater = buffer.readDouble();
        this.throBlock = buffer.readDouble();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.rayCastId);
        buffer.m_130068_((Enum)this.perspective);
        buffer.writeInt(this.perspectiveEntityId);
        UtilPacket.writeVec3(this.targetPos, buffer);
        buffer.writeDouble(this.throWater);
        buffer.writeDouble(this.throBlock);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> DistantRayCastManagerClient.handleS2CRayCast(this.rayCastId, this.perspective, this.perspectiveEntityId, this.targetPos, this.throWater, this.throBlock));
    }

    public MessageType getType() {
        return OWLPacketHandler.S2C_RAY_CAST;
    }
}

