/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.data.jsonpreset.PresetBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientStackBuilder<C extends IngredientStackBuilder<C>>
extends PresetBuilder<C> {
    public static NonNullList<Ingredient> getIngredients(JsonObject jsonPresetData, String listName) {
        NonNullList ingredients = NonNullList.m_122779_();
        if (!jsonPresetData.has(listName)) {
            return ingredients;
        }
        JsonArray ja = jsonPresetData.get(listName).getAsJsonArray();
        for (int i = 0; i < ja.size(); ++i) {
            JsonObject jo = ja.get(i).getAsJsonObject();
            int cost = jo.get("num").getAsInt();
            if (jo.has("tag")) {
                ingredients.add((Object)IngredientStack.fromTag(jo.get("tag").getAsString(), cost));
                continue;
            }
            if (!jo.has("item")) continue;
            ingredients.add((Object)IngredientStack.fromItem(jo.get("item").getAsString(), cost));
        }
        return ingredients;
    }

    public static NonNullList<Ingredient> getIngredients(JsonObject jsonPresetData) {
        return IngredientStackBuilder.getIngredients(jsonPresetData, "ingredients");
    }

    public String getIngredientListName() {
        return "ingredients";
    }

    protected IngredientStackBuilder(String namespace, String name, JsonPresetType type) {
        super(namespace, name, type);
    }

    protected IngredientStackBuilder(String namespace, String name, JsonPresetType type, JsonObject copy) {
        super(namespace, name, type, copy);
    }

    protected C addIngredient(@Nullable String itemId, @Nullable String tagId, int num) {
        if (!this.getData().has(this.getIngredientListName())) {
            this.getData().add(this.getIngredientListName(), (JsonElement)new JsonArray());
        }
        JsonObject i = new JsonObject();
        if (itemId != null) {
            i.addProperty("item", itemId);
        }
        if (tagId != null) {
            i.addProperty("tag", tagId);
        }
        i.addProperty("num", (Number)num);
        this.getData().get(this.getIngredientListName()).getAsJsonArray().add((JsonElement)i);
        return (C)this;
    }

    public C addIngredient(String itemId, int num) {
        return this.addIngredient(itemId, null, num);
    }

    public C addIngredient(String itemId) {
        return this.addIngredient(itemId, 1);
    }

    public C addIngredient(ResourceLocation item, int num) {
        return this.addIngredient(item.toString(), num);
    }

    public C addIngredient(ResourceLocation item) {
        return this.addIngredient(item, 1);
    }

    public C addIngredientTag(String tagId, int num) {
        return this.addIngredient(null, tagId, num);
    }

    public C addIngredientTag(String tagId) {
        return this.addIngredientTag(tagId, 1);
    }

    public C addIngredientTag(ResourceLocation tagId, int num) {
        return this.addIngredientTag(tagId.toString(), num);
    }

    public C addIngredientTag(ResourceLocation tagId) {
        return this.addIngredientTag(tagId.toString(), 1);
    }
}

