/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.entityscreen.EntityScreenTypes;
import com.onewhohears.dscombat.client.entityscreen.instance.AOAScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.AirRadarScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.AltimeterScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.AttitudeScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.BigRadarScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.FuelScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.GroundRadarScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.HeadingScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.HudScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.RWRScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.SpeedScreenInstance;
import com.onewhohears.dscombat.client.entityscreen.instance.TurnCoordScreenInstance;
import com.onewhohears.dscombat.client.event.ClientCameraEventHandlers;
import com.onewhohears.dscombat.client.event.ClientInputEventHandlers;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.model.obj.customanims.DSCAnimControl;
import com.onewhohears.dscombat.client.model.obj.customanims.VehicleModelTransforms;
import com.onewhohears.dscombat.client.overlay.OverlayController;
import com.onewhohears.dscombat.client.particle.AfterBurnerParticle;
import com.onewhohears.dscombat.client.particle.BigFlameParticle;
import com.onewhohears.dscombat.client.particle.ContrailParticle;
import com.onewhohears.dscombat.client.particle.FlareParticle;
import com.onewhohears.dscombat.client.particle.LargeSmokeCloudParticle;
import com.onewhohears.dscombat.client.particle.ShrapnelParticle;
import com.onewhohears.dscombat.client.renderer.EntityScreenRenderer;
import com.onewhohears.dscombat.client.screen.VehicleBlockScreen;
import com.onewhohears.dscombat.client.screen.VehiclePartsScreen;
import com.onewhohears.dscombat.client.screen.VehicleScreen;
import com.onewhohears.dscombat.client.screen.VehicleStorageScreen;
import com.onewhohears.dscombat.client.screen.WeaponPartsBlockScreen;
import com.onewhohears.dscombat.client.screen.WeaponsBlockScreen;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.sound.PassengerSoundPack;
import com.onewhohears.dscombat.init.ModContainers;
import com.onewhohears.dscombat.init.ModFluids;
import com.onewhohears.dscombat.init.ModParticles;
import com.onewhohears.onewholibs.client.model.obj.customanims.CustomAnims;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.ControllableAnimPlayer;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KFAnimPlayers;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ClientEventHandlers {
    public static void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(ClientEventHandlers::onClientSetup);
        ClientGuiEvent.RENDER_HUD.register(ClientEventHandlers::onRenderHud);
        OWLEvents.SYNC_BOOL_GAME_RULE.register(ClientEventHandlers::onSyncGameRuleBool);
        ClientChatEvent.RECEIVED.register(ClientEventHandlers::receivedChat);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(ClientInputEventHandlers::onClientPlayerJoin);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(ClientEventHandlers::onClientPlayerQuit);
        ClientTickEvent.CLIENT_PRE.register(ClientEventHandlers::onClientTickPre);
    }

    public static void onClientTickPre(Minecraft minecraft) {
        ClientInputEventHandlers.clientTickPilotControl(minecraft);
        ClientCameraEventHandlers.clientTickSetMouseCallback(minecraft);
    }

    public static void onClientPlayerQuit(@Nullable LocalPlayer localPlayer) {
        EntityScreenRenderer.clearCache();
    }

    public static CompoundEventResult<Component> receivedChat(ChatType.Bound bound, Component message) {
        ResourceLocation typeId = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_235730_).m_7981_((Object)bound.f_240859_());
        if (typeId == null) {
            return CompoundEventResult.pass();
        }
        if (typeId.m_135815_().equals("chat")) {
            return CompoundEventResult.pass();
        }
        Minecraft m = Minecraft.m_91087_();
        Screen screen = m.f_91080_;
        if (!(screen instanceof VehicleScreen)) {
            return CompoundEventResult.pass();
        }
        VehicleScreen screen2 = (VehicleScreen)screen;
        screen2.setInfoFromMessage(message, 60);
        return CompoundEventResult.pass();
    }

    public static void onSyncGameRuleBool(String id, boolean value) {
        if (id.equals(DSCGameRules.DISABLE_3RD_PERSON_VEHICLE.m_46328_())) {
            DSCClientInputs.disable3rdPersonVehicle = value;
        } else if (id.equals(DSCGameRules.PLANE_ARCADE_MODE.m_46328_())) {
            DSCClientInputs.planeArcadePhysicsMode = value;
        }
    }

    public static void onRenderHud(PoseStack poseStack, float partialTicks) {
        OverlayController.onRenderHud(poseStack, partialTicks);
    }

    public static void onClientSetup(Minecraft minecraft) {
        ClientEventHandlers.registerScreens();
        ClientEventHandlers.registerCustomAnims();
        ClientEventHandlers.registerKeyframeAnims();
        ClientEventHandlers.setFluidRenderLayers();
        ClientEventHandlers.registerEntityScreens();
        PassengerSoundPack.registerBuiltInPassengerSoundTriggers();
    }

    public static void registerParticleProvider() {
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.LARGE_SMOKE_CLOUD.get()), LargeSmokeCloudParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.SHRAPNEL.get()), ShrapnelParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.BIG_FLAME.get()), BigFlameParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.CONTRAIL.get()), ContrailParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.AFTER_BURNER.get()), AfterBurnerParticle.Provider::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ModParticles.FLARE.get()), FlareParticle.Provider::new);
    }

    public static void registerEntityScreens() {
        EntityScreenTypes.addScreenType(11, BigRadarScreenInstance::new, "008282");
        EntityScreenTypes.addScreenType(0, AirRadarScreenInstance::new, "00FFFF");
        EntityScreenTypes.addScreenType(4, GroundRadarScreenInstance::new, "4CFF00");
        EntityScreenTypes.addScreenType(1, FuelScreenInstance::new, "7F0000");
        EntityScreenTypes.addScreenType(2, HudScreenInstance::new, "");
        EntityScreenTypes.addScreenType(3, RWRScreenInstance::new, "FF00DC");
        EntityScreenTypes.addScreenType(5, HeadingScreenInstance::new, "0026FF");
        EntityScreenTypes.addScreenType(10, TurnCoordScreenInstance::new, "008718");
        EntityScreenTypes.addScreenType(7, AttitudeScreenInstance::new, "7F3300");
        EntityScreenTypes.addScreenType(9, AOAScreenInstance::new, "840084");
        EntityScreenTypes.addScreenType(8, AltimeterScreenInstance::new, "848400");
        EntityScreenTypes.addScreenType(6, SpeedScreenInstance::new, "FFD800");
    }

    public static void setFluidRenderLayers() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Fluid[])new Fluid[]{(Fluid)ModFluids.getOilFluidSource().get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Fluid[])new Fluid[]{(Fluid)ModFluids.getOilFluidFlowing().get()});
    }

    public static void registerKeyframeAnims() {
        KFAnimPlayers.addAnimationPlayerFactory((String)"turret_shoot", data -> new ControllableAnimPlayer(data, DSCAnimControl.TURRET_SHOOT_TRIGGER, DSCAnimControl.TURRET_SHOOT_CONTROL));
        KFAnimPlayers.addAnimationPlayerFactory((String)"turret_shoot_loop", data -> new ControllableAnimPlayer(data, DSCAnimControl.TURRET_SHOOT_LOOP_TRIGGER, DSCAnimControl.TURRET_SHOOT_LOOP_CONTROL));
        KFAnimPlayers.addAnimationPlayerFactory((String)"turret_shoot_loop_end", data -> new ControllableAnimPlayer(data, DSCAnimControl.TURRET_SHOOT_LOOP_END_TRIGGER, DSCAnimControl.TURRET_SHOOT_LOOP_END_CONTROL));
        KFAnimPlayers.addAnimationPlayerFactory((String)"vehicle_landing_gear", data -> new ControllableAnimPlayer(data, DSCAnimControl.LANDING_GEAR_TRIGGER, DSCAnimControl.LANDING_GEAR_CONTROL));
    }

    public static void registerCustomAnims() {
        CustomAnims.addAnim((String)"input_bound_translation", VehicleModelTransforms.InputBoundTranslation::new);
        CustomAnims.addAnim((String)"motor_rotation", VehicleModelTransforms.MotorRotation::new);
        CustomAnims.addAnim((String)"wheel_rotation", VehicleModelTransforms.WheelRotation::new);
        CustomAnims.addAnim((String)"input_bound_rotation", VehicleModelTransforms.InputBoundRotation::new);
        CustomAnims.addAnim((String)"spinning_radar", VehicleModelTransforms.SpinningRadar::new);
        CustomAnims.addAnim((String)"landing_gear", VehicleModelTransforms.LandingGear::new);
        CustomAnims.addAnim((String)"hitbox_destroy_part", VehicleModelTransforms.HitboxDestroyPart::new);
        CustomAnims.addAnim((String)"plane_flap_rotation", VehicleModelTransforms.PlaneFlapRotation::new);
        CustomAnims.addAnim((String)"turret_rotation", VehicleModelTransforms.TurretRotation::new);
    }

    public static void registerScreens() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_PARTS_MENU.get()), VehiclePartsScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.WEAPONS_BLOCK_MENU.get()), WeaponsBlockScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.WEAPON_PARTS_BLOCK_MENU.get()), WeaponPartsBlockScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.AIRCRAFT_BLOCK_MENU.get()), VehicleBlockScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x0.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x1.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x2.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x3.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x4.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x5.get()), VehicleStorageScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModContainers.VEHICLE_STORAGE_MENU_9x6.get()), VehicleStorageScreen::new);
    }
}

