/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.model.obj.ObjPartModel;
import com.onewhohears.dscombat.entity.parts.EntityRadar;
import com.onewhohears.onewholibs.client.model.obj.ObjBakedModel;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.client.model.obj.ObjModelHandler;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ObjRadarModel
extends ObjPartModel<EntityRadar> {
    @Nullable
    protected final String largeModelId;
    @Nullable
    private ObjModelHandler largeModel;
    @Nullable
    private ObjEntityModels.ModelOverrides largeOverride;
    protected MastType currentMastType = MastType.NONE;

    public ObjRadarModel(String modelId) {
        this(modelId, (String)null, new String[0]);
    }

    public ObjRadarModel(String modelId, String largeModelId, String ... animDataIds) {
        this(modelId, largeModelId, new JsonArray(), animDataIds);
    }

    public ObjRadarModel(String modelId, String largeModelId, JsonArray customAnims, String ... animDataIds) {
        super(modelId, customAnims, animDataIds);
        this.largeModelId = largeModelId;
    }

    @Override
    public void render(EntityRadar entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        ObjBakedModel mastModel;
        if (!entity.shouldRender()) {
            return;
        }
        this.currentMastType = entity.getVehicleMastType();
        poseStack.m_85837_(0.0, (double)this.currentMastType.radarTopPos, 0.0);
        super.render(entity, poseStack, bufferSource, lightmap, partialTicks);
        if (!this.currentMastType.isNone() && (mastModel = ObjEntityModels.get().getBakedModel(this.currentMastType.modelId)) != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)(-this.currentMastType.radarTopPos), 0.0);
            mastModel.render(poseStack, bufferSource, RenderType::m_110446_, this.getLight(entity, lightmap), this.getOverlay((Entity)entity), partialTicks, NO_TRANSFORMS);
            poseStack.m_85849_();
        }
    }

    public ObjModelHandler getObjModelHandler() {
        if (this.currentMastType.isLarge() && this.largeModelId != null && !this.largeModelId.isEmpty()) {
            if (this.largeModel == null) {
                this.largeModel = ObjEntityModels.get().getObjModelHandler(this.largeModelId);
            }
            return this.largeModel;
        }
        return super.getObjModelHandler();
    }

    public ObjEntityModels.ModelOverrides getModelOverride() {
        if (this.currentMastType.isLarge() && this.largeModelId != null && !this.largeModelId.isEmpty()) {
            if (this.largeOverride == null) {
                this.largeOverride = ObjEntityModels.get().getModelOverride(this.largeModelId);
            }
            return this.largeOverride;
        }
        return super.getModelOverride();
    }

    public static enum MastType {
        NONE("", 0.0f),
        THIN("thin_mast", 3.5f),
        NORMAL("normal_mast", 3.125f),
        LARGE("thick_mast", 3.0f);

        public final String modelId;
        public final float radarTopPos;

        private MastType(String modelId, float radarTopPos) {
            this.modelId = modelId;
            this.radarTopPos = radarTopPos;
        }

        public boolean isLarge() {
            return this == LARGE;
        }

        public boolean isNone() {
            return this == NONE;
        }
    }
}

