/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.client.overlay.OverlayController;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AimAssistOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation AIM_HUD = new ResourceLocation("dscombat", "textures/ui/aim_hud.png");
    public static final int AIM_SIZE = 10;
    protected static float PARTIAL_TICK;
    private Vec3 targetWorldPos = null;
    private int prevTick = 0;

    @Override
    protected boolean shouldRender(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (AimAssistOverlay.defaultRenderConditions()) {
            return false;
        }
        Entity entity = AimAssistOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return false;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        RadarSystem radar = vehicle.radarSystem;
        if (!radar.hasRadar()) {
            return false;
        }
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (data == null) {
            return false;
        }
        return ((WeaponStats)data.getStats()).isAimAssist();
    }

    @Override
    protected void render(Gui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        Entity entity = AimAssistOverlay.getPlayerRootVehicle();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        WeaponInstance<?> data = vehicle.weaponSystem.getSelected();
        if (vehicle.f_19797_ != this.prevTick) {
            assert (data != null);
            this.targetWorldPos = this.calcTargetWorldPos(vehicle, data);
        }
        this.prevTick = vehicle.f_19797_;
        if (this.targetWorldPos == null) {
            return;
        }
        Camera cam = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 view = cam.m_90583_();
        float z_rot = UtilAngles.lerpAngle((float)PARTIAL_TICK, (float)vehicle.zRotO, (float)vehicle.zRot);
        stack.m_85836_();
        QuaternionF q = Vec3f.ZP.rotationDegrees(z_rot);
        q.mul(Vec3f.XP.rotationDegrees(cam.m_90589_()));
        q.mul(Vec3f.YP.rotationDegrees(cam.m_90590_() + 180.0f));
        stack.m_85845_(q.convert());
        stack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Mat4f view_mat = Mat4f.from((Matrix4f)stack.m_85850_().m_85861_().m_27658_());
        stack.m_85849_();
        Mat4f proj_mat = OverlayController.PROJECTION_MATRIX;
        float[] screen_pos = UtilGeometry.worldToScreenPos((Vec3)this.targetWorldPos, (Mat4f)view_mat, (Mat4f)proj_mat, (int)screenWidth, (int)screenHeight);
        if (screen_pos[0] < 0.0f || screen_pos[1] < 0.0f) {
            return;
        }
        float x_win = screen_pos[0];
        float y_win = screen_pos[1];
        float adj = 5.0f;
        float x_pos = x_win - adj;
        float y_pos = y_win - adj;
        this.drawCrossHair(stack, x_pos, y_pos);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_aim_assist";
    }

    protected void drawCrossHair(PoseStack poseStack, float x_pos, float y_pos) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x_pos, (double)y_pos, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AIM_HUD);
        AimAssistOverlay.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
        poseStack.m_85849_();
    }

    @Nullable
    protected Vec3 calcTargetWorldPos(EntityVehicle vehicle, WeaponInstance<?> data) {
        return data.estimateImpactPosition(vehicle);
    }
}

