/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VehicleControlOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation RUDDER_PEDAL = new ResourceLocation("dscombat", "textures/ui/rudder_pedal.png");
    public static final ResourceLocation RUDDER_PEDAL_PUSHED = new ResourceLocation("dscombat", "textures/ui/rudder_pedal_pushed.png");
    public static final ResourceLocation STICK_BASE = new ResourceLocation("dscombat", "textures/ui/stick_base.png");
    public static final ResourceLocation STICK_KNOB = new ResourceLocation("dscombat", "textures/ui/stick_knob.png");
    public static final int STICK_BASE_SIZE = 60;
    public static final int STICK_KNOB_SIZE = 10;
    protected static int PEDAL_HEIGHT = 25;
    protected static int PEDAL_WIDTH = 20;

    @Override
    protected boolean shouldRender(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleControlOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue() && !((Boolean)Config.CLIENT.showControlsInModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleControlOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleControlOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 1;
        if (vehicle.isAircraft()) {
            yOrigin -= PEDAL_HEIGHT;
            if (vehicle.inputs.yaw < 0.0f) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)RUDDER_PEDAL_PUSHED);
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)RUDDER_PEDAL);
            }
            VehicleControlOverlay.m_93133_((PoseStack)poseStack, (int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT);
            if (vehicle.inputs.yaw > 0.0f) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)RUDDER_PEDAL_PUSHED);
            } else {
                RenderSystem.m_157456_((int)0, (ResourceLocation)RUDDER_PEDAL);
            }
            VehicleControlOverlay.m_93133_((PoseStack)poseStack, (int)(xOrigin + 60 - PEDAL_WIDTH), (int)yOrigin, (float)0.0f, (float)0.0f, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT, (int)PEDAL_WIDTH, (int)PEDAL_HEIGHT);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)STICK_BASE);
        VehicleControlOverlay.m_93133_((PoseStack)poseStack, (int)xOrigin, (int)(yOrigin -= 60), (float)0.0f, (float)0.0f, (int)60, (int)60, (int)60, (int)60);
        RenderSystem.m_157456_((int)0, (ResourceLocation)STICK_KNOB);
        int baseSizeHalf = 30;
        int knobSizeHalf = 5;
        float yinput = vehicle.inputs.pitch;
        float xinput = vehicle.isAircraft() ? vehicle.inputs.roll : vehicle.inputs.yaw;
        float inputLength = Mth.m_14116_((float)(xinput * xinput + yinput * yinput));
        if (inputLength > 1.0f) {
            xinput /= inputLength;
            yinput /= inputLength;
        }
        VehicleControlOverlay.m_93133_((PoseStack)poseStack, (int)(xOrigin + baseSizeHalf - knobSizeHalf + (int)(xinput * (float)baseSizeHalf)), (int)(yOrigin + baseSizeHalf - knobSizeHalf + (int)(yinput * (float)baseSizeHalf)), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_controls";
    }
}

