/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class VehicleWeaponsOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation WEAPON_TABS = new ResourceLocation("dscombat", "textures/ui/weapon_icons/weapon_tab.png");
    public static final ResourceLocation SELECTOR = new ResourceLocation("dscombat", "textures/ui/weapon_icons/selection_box.png");
    public static final byte TAB_WIDTH = 93;
    public static final byte TAB_HEIGHT = 24;
    public static final float[] FRAMES = new float[]{0.0f, 5.0f, 10.0f, 13.0f, 16.0f, 18.0f, 20.0f, 22.0f, 23.0f};
    public static final int[] SPACINGS = new int[]{24, 21, 18, 12, 0};
    public static final Component SAFETY = UtilMCText.translatable((String)"ui.dscombat.no_weapon");
    protected boolean weaponChangeState;
    protected boolean weaponChangeQueued;
    protected int weaponChangeCountdown;
    protected int selectedWeapon;
    protected float frame;
    protected int superFrame;

    @Override
    protected boolean shouldRender(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleWeaponsOverlay.defaultRenderConditions()) {
            return false;
        }
        return VehicleWeaponsOverlay.getPlayerVehicle() instanceof EntityRidablePart;
    }

    @Override
    protected void render(Gui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)VehicleWeaponsOverlay.getPlayerVehicle();
        assert (seat != null);
        double yPlacement = screenHeight - 24 - 13;
        int blitPosition = 1;
        if (seat.isTurret()) {
            VehicleWeaponsOverlay.drawFinishedTab(poseStack, ((EntityTurret)seat).getWeaponData(), yPlacement, blitPosition);
            return;
        }
        if (!seat.canPassengerShootParentWeapon()) {
            return;
        }
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        List<WeaponInstance<?>> weapons = vehicle.weaponSystem.getWeapons();
        WeaponInstance<?> selectedWeapon = vehicle.weaponSystem.getSelected();
        int selectedIndex = vehicle.weaponSystem.getSelectedIndex();
        if (weapons == null || weapons.isEmpty()) {
            return;
        }
        if (selectedWeapon == null) {
            return;
        }
        if (selectedIndex != this.selectedWeapon) {
            this.enableWeaponChangeState();
        }
        this.selectedWeapon = selectedIndex;
        if (this.weaponChangeCountdown <= 0) {
            this.weaponChangeState = false;
        }
        if (!this.weaponChangeState) {
            VehicleWeaponsOverlay.drawFinishedTab(poseStack, selectedWeapon, yPlacement, blitPosition);
        } else {
            int weaponTabsToRender = Math.min(weapons.size(), 5);
            for (int i = 0; i < weaponTabsToRender; ++i) {
                int shiftedIndex = selectedIndex - i;
                if (shiftedIndex < 0) {
                    shiftedIndex = (shiftedIndex % weapons.size() + weapons.size()) % weapons.size();
                }
                int newYPos = (int)(yPlacement - (double)(24 * i));
                WeaponInstance<?> weaponAt = weapons.get(shiftedIndex);
                VehicleWeaponsOverlay.drawTab(poseStack, 13.0, newYPos, blitPosition, 0, false);
                VehicleWeaponsOverlay.drawWeapon(poseStack, weaponAt, 13.0, newYPos, blitPosition + 1, 0, false, false, false);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)(blitPosition + 3));
                if (!((WeaponStats)weaponAt.getStats()).isNoWeapon()) {
                    VehicleWeaponsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)(weaponAt.getCurrentAmmo() + "/" + weaponAt.getMaxAmmo()), (int)16, (int)(newYPos + 14), (int)0xE6E600);
                } else {
                    VehicleWeaponsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)SAFETY, (int)16, (int)(newYPos + 14), (int)0xFF5555);
                }
                VehicleWeaponsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)((WeaponStats)weaponAt.getStats()).getDisplayNameComponent(), (int)16, (int)(newYPos + 4), (int)0xFFFFFF);
                poseStack.m_85849_();
            }
            VehicleWeaponsOverlay.renderSelectionBox(poseStack, 13.0, yPlacement, blitPosition + 2);
            --this.weaponChangeCountdown;
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_weapons";
    }

    public void queueWeaponChange() {
        this.weaponChangeQueued = true;
    }

    public void enableWeaponChangeState() {
        this.weaponChangeCountdown = 200;
        this.weaponChangeState = true;
        VehicleWeaponsOverlay.getPlayer().m_216990_(SoundEvents.f_12490_);
    }

    protected static void drawFinishedTab(PoseStack poseStack, WeaponInstance<?> selectedWeapon, double yPlacement, int blitPosition) {
        if (selectedWeapon == null) {
            return;
        }
        VehicleWeaponsOverlay.drawWeaponName(poseStack, (Component)((WeaponStats)selectedWeapon.getStats()).getDisplayNameComponent(), 13.0, yPlacement, blitPosition - 2);
        VehicleWeaponsOverlay.drawTab(poseStack, 13.0, yPlacement, blitPosition, 0, false);
        VehicleWeaponsOverlay.drawWeapon(poseStack, selectedWeapon, 13.0, yPlacement, blitPosition + 1, 0, false, false, false);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)(blitPosition + 2));
        if (!((WeaponStats)selectedWeapon.getStats()).isNoWeapon()) {
            VehicleWeaponsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)(selectedWeapon.getCurrentAmmo() + "/" + selectedWeapon.getMaxAmmo()), (int)16, (int)((int)(yPlacement + 14.0)), (int)0xE6E600);
        }
        VehicleWeaponsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)((WeaponStats)selectedWeapon.getStats()).getWeaponTypeCode(), (int)16, (int)((int)yPlacement + 4), (int)0xE6E600);
        poseStack.m_85849_();
    }

    protected static void drawTab(PoseStack stack, double x, double y, int blitOffset, int frame, boolean scrollsUpward) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        float sign = scrollsUpward ? -1.0f : 1.0f;
        stack.m_85836_();
        stack.m_85837_(x, y, (double)blitOffset);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WEAPON_TABS);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        VehicleWeaponsOverlay.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)(sign * FRAMES[frame]), (int)93, (int)24, (int)93, (int)24);
        RenderSystem.m_69461_();
        RenderSystem.m_69465_();
        stack.m_85849_();
    }

    protected static void drawWeapon(PoseStack stack, WeaponInstance<?> weapon, double x, double y, int blitOffset, int frame, boolean scrollsUpward, boolean scrollsToBlank, boolean scrollsFromBlank) {
        if (frame < 0 || frame > VehicleWeaponsOverlay.getMaxFrames() - 1) {
            throw new IllegalArgumentException("There are only " + VehicleWeaponsOverlay.getMaxFrames() + " frames!");
        }
        if (scrollsToBlank && scrollsFromBlank) {
            throw new IllegalArgumentException("Tabs may not scroll to and from blank!");
        }
        if (weapon == null) {
            throw new NullPointerException("Passed weapon is null!");
        }
        int frameValue = (int)FRAMES[frame];
        RenderSystem.m_157456_((int)0, (ResourceLocation)((WeaponStats)weapon.getStats()).getWeaponIcon());
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        stack.m_85836_();
        if (scrollsUpward) {
            stack.m_85837_(x, y + (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(stack, 24 - frameValue);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(stack, frameValue);
            }
        } else {
            stack.m_85837_(x, y - (double)frameValue, (double)blitOffset);
            if (scrollsFromBlank) {
                VehicleWeaponsOverlay.blitWithoutBottom(stack, 24 - frameValue);
            }
            if (scrollsToBlank) {
                VehicleWeaponsOverlay.blitWithoutTop(stack, frameValue);
            }
        }
        if (!scrollsFromBlank && !scrollsToBlank) {
            VehicleWeaponsOverlay.blitNormal(stack);
        }
        stack.m_85849_();
        RenderSystem.m_69461_();
        RenderSystem.m_69465_();
    }

    protected static void drawWeaponName(PoseStack stack, Component name, double x, double y, int blitOffset) {
        stack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        int nameWidth = FONT.m_92852_((FormattedText)name);
        Objects.requireNonNull(FONT);
        int nameHeight = 9;
        int blitOffsetUnder = blitOffset - 1;
        int xPosInitial = (int)x + 1;
        int xPosFinal = xPosInitial + nameWidth + 6;
        int yPosInitial = (int)y - 12;
        int yPosFinal = yPosInitial + nameHeight + 5;
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(xPosInitial - 1), (int)yPosInitial, (int)xPosInitial, (int)(yPosFinal + 1), (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)yPosInitial, (int)xPosFinal, (int)yPosFinal, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)(yPosInitial - 1), (int)xPosFinal, (int)yPosInitial, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)yPosFinal, (int)xPosFinal, (int)(yPosFinal + 1), (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosFinal, (int)yPosInitial, (int)(xPosFinal + 1), (int)yPosFinal, (int)blitOffsetUnder, (int)-267386864, (int)-267386864);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)(yPosInitial + 1), (int)(xPosInitial + 1), (int)(yPosFinal - 1), (int)blitOffsetUnder, (int)0x505000FF, (int)1344798847);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(xPosFinal - 1), (int)(yPosInitial + 1), (int)xPosFinal, (int)(yPosFinal - 1), (int)blitOffsetUnder, (int)0x505000FF, (int)1344798847);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)yPosInitial, (int)xPosFinal, (int)(yPosInitial + 1), (int)blitOffsetUnder, (int)0x505000FF, (int)0x505000FF);
        VehicleWeaponsOverlay.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)xPosInitial, (int)(yPosFinal - 1), (int)xPosFinal, (int)yPosFinal, (int)blitOffsetUnder, (int)1344798847, (int)1344798847);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        stack.m_85837_(x, y - 11.0, (double)blitOffset);
        FONT.m_92841_(name, 4.0f, 2.0f, -1, true, matrix4f, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        bufferSource.m_109911_();
        stack.m_85849_();
    }

    protected static void renderSelectionBox(PoseStack stack, double x, double y, int blitOffset) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)SELECTOR);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        stack.m_85836_();
        stack.m_85837_(x, y, (double)blitOffset);
        VehicleWeaponsOverlay.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)24, (int)93, (int)24);
        stack.m_85849_();
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
    }

    protected static void blitNormal(PoseStack stack) {
        VehicleWeaponsOverlay.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)24, (int)93, (int)24);
    }

    protected static void blitWithoutTop(PoseStack stack, int trimPixels) {
        VehicleWeaponsOverlay.m_93133_((PoseStack)stack, (int)0, (int)trimPixels, (float)0.0f, (float)trimPixels, (int)93, (int)(24 - trimPixels), (int)93, (int)24);
    }

    protected static void blitWithoutBottom(PoseStack stack, int trimPixels) {
        VehicleWeaponsOverlay.m_93133_((PoseStack)stack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)93, (int)(24 - trimPixels), (int)93, (int)24);
    }

    protected static int getMaxFrames() {
        return FRAMES.length;
    }
}

