/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.common.container.menu.VehicleBlockContainerMenu;
import com.onewhohears.dscombat.common.network.toserver.ToServerCraftPlane;
import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VehicleBlockScreen
extends AbstractContainerScreen<VehicleBlockContainerMenu> {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/vehicle_forge_ui.png");
    private final int bg_tex_size;
    private AircraftTab tab = AircraftTab.TANKS;
    private List<Integer> fails = new ArrayList<Integer>();

    public VehicleBlockScreen(VehicleBlockContainerMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97726_ = 352;
        this.f_97727_ = 260;
        this.bg_tex_size = 512;
        this.f_97728_ = 122;
        this.f_97729_ = 24;
        this.f_97730_ = 96;
        this.f_97731_ = 146;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        this.renderBookmark(poseStack, mouseX, mouseY, partialTicks);
        this.renderIngredients(poseStack, mouseX, mouseY, partialTicks);
        this.renderVehicle(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(PoseStack stack, float pTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_TEXTURE);
        VehicleBlockScreen.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.bg_tex_size, (int)this.bg_tex_size);
    }

    protected void renderBookmark(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_TEXTURE);
        VehicleBlockScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + this.tab.getBookmarkXPos()), (int)this.f_97736_, (float)352.0f, (float)0.0f, (int)7, (int)11, (int)this.bg_tex_size, (int)this.bg_tex_size);
    }

    protected void renderVehicle(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        ItemStack stack = ap.m_8043_();
        int posX = this.f_97735_ + 170;
        int posY = this.f_97736_ + 52;
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        float scale = 3.0f;
        float scaleInv = 1.0f / scale;
        modelViewStack.m_85841_(scale, scale, scale);
        float blitOffset = 100.0f + this.f_96541_.m_91291_().f_115093_ + 50.0f;
        modelViewStack.m_85837_((double)((float)(posX + 8) * scaleInv), 0.0, (double)blitOffset);
        long time = Util.m_137550_();
        float spinRate = 0.1f;
        modelViewStack.m_85845_(Vec3f.YP.rotationDegrees((float)time * spinRate).convert());
        modelViewStack.m_85837_((double)((float)(-(posX + 8)) * scaleInv), 0.0, (double)(-blitOffset));
        modelViewStack.m_85837_((double)((float)(posX + 8) * (scaleInv - 1.0f)), (double)((float)(posY + 8) * (scaleInv - 1.0f)), 0.0);
        this.f_96541_.m_91291_().m_115203_(stack, posX, posY);
        modelViewStack.m_85849_();
    }

    protected void renderIngredients(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        NonNullList<Ingredient> ingredients = ap.m_7527_();
        for (int i = 0; i < ((VehicleBlockContainerMenu)this.m_6262_()).recipeSlots.m_6643_(); ++i) {
            if (i < ingredients.size()) {
                ItemStack[] items = ((Ingredient)ingredients.get(i)).m_43908_();
                ItemStack stack = items.length == 0 ? Items.f_42127_.m_7968_() : items[m.f_91074_.f_19797_ / 20 % items.length];
                ((VehicleBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, stack);
                if (!this.fails.contains(i)) continue;
                Slot slot = ((VehicleBlockContainerMenu)this.m_6262_()).m_38853_(i);
                int left = this.f_97735_ + slot.f_40220_;
                int top = this.f_97736_ + slot.f_40221_;
                VehicleBlockScreen.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + 17), (int)(top + 17), (int)0x77FF0000);
                continue;
            }
            ((VehicleBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, ItemStack.f_41583_);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        VehicleRecipe ar = this.tab.getSelectedRecipe();
        if (ar == null) {
            return;
        }
        VehicleStats ap = ar.getVehicleStats();
        if (ap == null) {
            return;
        }
        MutableComponent name = ap.getDisplayNameComponent();
        int nameWidth = this.f_96547_.m_92852_((FormattedText)name);
        this.f_96547_.m_92889_(stack, (Component)name, (float)(this.f_97728_ - nameWidth / 2 + 54), (float)this.f_97729_, 0);
        CompoundTag data = ap.getDataAsNBT().m_128469_("stats");
        float scale = 1.0f;
        stack.m_85841_(scale, scale, scale);
        float invScale = 1.0f / scale;
        int startX = (int)(293.0f * invScale);
        int startY = (int)(34.0f * invScale);
        int pColor = 5046016;
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.health").m_130946_(": " + data.m_128459_("max_health")), (float)startX, (float)startY, pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.speed").m_130946_(": " + (int)(data.m_128459_("max_speed") * 20.0) + " m/s"), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.mass").m_130946_(": " + data.m_128459_("mass")), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.cross_sec_area").m_130946_(": " + data.m_128459_("cross_sec_area")), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.stealth").m_130946_(": " + data.m_128459_("stealth")), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.heat").m_130946_(": " + data.m_128459_("idleheat")), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.armor").m_130946_(": " + data.m_128457_("base_armor")), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.yaw_rate").m_130946_(": " + (int)(data.m_128459_("maxyaw") * 20.0) + " d/s"), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.pitch_rate").m_130946_(": " + (int)(data.m_128459_("maxpitch") * 20.0) + " d/s"), (float)startX, (float)(startY += 9), pColor);
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, (Component)UtilMCText.translatable((String)"info.dscombat.roll_rate").m_130946_(": " + (int)(data.m_128459_("maxroll") * 20.0) + " d/s"), (float)startX, (float)(startY += 9), pColor);
        stack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
    }

    protected void m_7856_() {
        super.m_7856_();
        ImageButton tankButton = new ImageButton(0, 0, 45, 20, 83, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.TANKS));
        tankButton.f_93620_ = this.f_97735_ + 83;
        tankButton.f_93621_ = this.f_97736_;
        this.m_142416_((GuiEventListener)tankButton);
        ImageButton heliButton = new ImageButton(0, 0, 45, 20, 130, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.HELIS));
        heliButton.f_93620_ = this.f_97735_ + 130;
        heliButton.f_93621_ = this.f_97736_;
        this.m_142416_((GuiEventListener)heliButton);
        ImageButton planeButton = new ImageButton(0, 0, 45, 20, 177, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.PLANES));
        planeButton.f_93620_ = this.f_97735_ + 177;
        planeButton.f_93621_ = this.f_97736_;
        this.m_142416_((GuiEventListener)planeButton);
        ImageButton boatButton = new ImageButton(0, 0, 45, 20, 224, 0, 300, BG_TEXTURE, 512, 512, onPress -> this.tabButton(AircraftTab.BOATS));
        boatButton.f_93620_ = this.f_97735_ + 224;
        boatButton.f_93621_ = this.f_97736_;
        this.m_142416_((GuiEventListener)boatButton);
        ImageButton prevButton = new ImageButton(0, 0, 41, 10, 78, 52, 230, BG_TEXTURE, 512, 512, onPress -> this.prevButton());
        prevButton.f_93620_ = this.f_97735_ + 78;
        prevButton.f_93621_ = this.f_97736_ + 52;
        this.m_142416_((GuiEventListener)prevButton);
        ImageButton nextButton = new ImageButton(0, 0, 41, 10, 233, 52, 230, BG_TEXTURE, 512, 512, onPress -> this.nextButton());
        nextButton.f_93620_ = this.f_97735_ + 233;
        nextButton.f_93621_ = this.f_97736_ + 52;
        this.m_142416_((GuiEventListener)nextButton);
        Button craftButton = new Button(0, 0, 80, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.craft_button"), onPress -> this.craftButton());
        craftButton.f_93620_ = this.f_97735_ + 140;
        craftButton.f_93621_ = this.f_97736_ + 86;
        this.m_142416_((GuiEventListener)craftButton);
    }

    private void tabButton(AircraftTab tab) {
        this.tab = tab;
        this.resetFails();
    }

    private void prevButton() {
        this.tab.cycleIndexLeft();
        this.resetFails();
    }

    private void nextButton() {
        this.tab.cycleIndexRight();
        this.resetFails();
    }

    private void craftButton() {
        this.resetFails();
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer player = m.f_91074_;
        if (player == null) {
            return;
        }
        VehicleRecipe ap = this.tab.getSelectedRecipe();
        if (ap == null) {
            return;
        }
        if (ap.matches(player.m_150109_(), (Level)m.f_91073_)) {
            new ToServerCraftPlane(ap.m_6423_(), ((VehicleBlockContainerMenu)this.f_97732_).getPos()).sendToServer();
        } else {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_craft"), true);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12507_, (float)1.0f));
            this.setFails(UtilItem.testRecipeFails(ap.m_7527_(), (Container)player.m_150109_()));
        }
    }

    public void setFails(List<Integer> fails) {
        if (fails == null) {
            return;
        }
        this.fails = fails;
    }

    public void resetFails() {
        this.fails.clear();
    }

    public static enum AircraftTab {
        TANKS(() -> VehiclePresets.get().getTankRecipes(Minecraft.m_91087_().f_91073_.m_7465_()), 86),
        HELIS(() -> VehiclePresets.get().getHeliRecipes(Minecraft.m_91087_().f_91073_.m_7465_()), 133),
        PLANES(() -> VehiclePresets.get().getPlaneRecipes(Minecraft.m_91087_().f_91073_.m_7465_()), 180),
        BOATS(() -> VehiclePresets.get().getBoatRecipes(Minecraft.m_91087_().f_91073_.m_7465_()), 227);

        private final int bookmarkX;
        private AircraftPresetList presetFactory;
        private int index = 0;

        private AircraftTab(AircraftPresetList presetFactory, int bookmarkX) {
            this.presetFactory = presetFactory;
            this.bookmarkX = bookmarkX;
        }

        public VehicleRecipe[] getRecipes() {
            return this.presetFactory.get();
        }

        public int getIndex() {
            return this.checkIndex();
        }

        private int checkIndex() {
            if (this.getRecipes().length == 0) {
                this.index = -1;
            } else if (this.index >= this.getRecipes().length) {
                this.index = this.getRecipes().length - 1;
            } else if (this.index < 0) {
                this.index = 0;
            }
            return this.index;
        }

        @Nullable
        public VehicleRecipe getSelectedRecipe() {
            if (this.checkIndex() == -1) {
                return null;
            }
            return this.getRecipes()[this.getIndex()];
        }

        public int cycleIndexRight() {
            ++this.index;
            if (this.index >= this.getRecipes().length) {
                this.index = 0;
            }
            return this.index;
        }

        public int cycleIndexLeft() {
            --this.index;
            if (this.index < 0) {
                this.index = this.getRecipes().length - 1;
            }
            return this.index;
        }

        public int getBookmarkXPos() {
            return this.bookmarkX;
        }
    }

    public static interface AircraftPresetList {
        public VehicleRecipe[] get();
    }
}

