/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.overlay.components.VehicleStatsOverlay;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitbox;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.Vec3f;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VehicleHealthScreen
extends VehicleSubScreen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_health_screen.png");
    public static final ResourceLocation FUEL_GAUGE = new ResourceLocation("dscombat", "textures/ui/fuel_guage.png");
    public static final ResourceLocation FUEL_GAUGE_ARROW = new ResourceLocation("dscombat", "textures/ui/fuel_guage_arrow.png");
    public static final int FUEL_GAUGE_HEIGHT = 40;
    public static final int FUEL_GAUGE_WIDTH = 60;
    public static final int FUEL_ARROW_HEIGHT = 7;
    public static final int FUEL_ARROW_WIDTH = 24;
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private int maxHitboxNameWidth;
    private MutableComponent[] hitboxNames;

    protected VehicleHealthScreen() {
        super("screen.dscombat.vehicle_health_screen", BG_TEXTURE, 240, 180, 256, 256);
        this.left_padding = 6;
        this.right_padding = 6;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        EntityVehicle vehicle = this.getVehicle();
        this.hitboxNames = new MutableComponent[vehicle.getHitboxes().size()];
        this.maxHitboxNameWidth = 0;
        for (int i = 0; i < vehicle.getHitboxes().size(); ++i) {
            this.hitboxNames[i] = UtilMCText.translatable((String)vehicle.getHitboxes().get(i).getHitboxName()).m_6270_(Style.f_131099_.m_178520_(43520));
            int width = this.f_96541_.f_91062_.m_92852_((FormattedText)this.hitboxNames[i]);
            if (width <= this.maxHitboxNameWidth) continue;
            this.maxHitboxNameWidth = width;
        }
        this.maxHitboxNameWidth += 10;
    }

    @Override
    public void m_7333_(@NotNull PoseStack poseStack) {
        super.m_7333_(poseStack);
        EntityVehicle vehicle = this.getVehicle();
        this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.translatable((String)"ui.dscombat.root_health").m_130946_(":" + (int)vehicle.getHealth() + "/" + (int)vehicle.getMaxHealth()), (float)(this.guiX + this.left_padding), (float)(this.guiY + this.top_padding + 40), VehicleHealthScreen.getHealthColor(vehicle.getHealth(), vehicle.getMaxHealth()));
        this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.translatable((String)"ui.dscombat.root_armor").m_130946_(":" + (int)vehicle.getArmor() + "/" + (int)vehicle.getMaxTotalArmor()), (float)(this.guiX + this.left_padding) + 120.0f, (float)(this.guiY + this.top_padding + 40), VehicleHealthScreen.getHealthColor(vehicle.getArmor(), vehicle.getMaxTotalArmor()));
        if (this.hitboxNames != null && this.hitboxNames.length > 0) {
            this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.translatable((String)"ui.dscombat.hitbox_health_armor"), (float)(this.guiX + this.left_padding), (float)(this.guiY + this.top_padding + 54), 170);
            float hitbox_scale = 0.6666667f;
            poseStack.m_85836_();
            poseStack.m_85841_(hitbox_scale, hitbox_scale, 1.0f);
            int startX = (int)((float)(this.guiX + this.left_padding) / hitbox_scale);
            int startY = (int)((float)(this.guiY + this.top_padding + 66) / hitbox_scale);
            for (int i = 0; i < vehicle.getHitboxes().size(); ++i) {
                RotableHitbox hitbox = vehicle.getHitboxes().get(i);
                float health = hitbox.getHealth();
                float max_health = hitbox.getMaxHealth();
                Style healthStyle = Style.f_131099_.m_178520_(VehicleHealthScreen.getHealthColor(health, max_health));
                float armor = hitbox.getArmor();
                float max_armor = hitbox.getMaxArmor();
                Style armorStyle = Style.f_131099_.m_178520_(VehicleHealthScreen.getHealthColor(armor, max_armor));
                this.f_96541_.f_91062_.m_92889_(poseStack, (Component)this.hitboxNames[i], (float)startX, (float)(startY + i * 10), 0xFFFFFF);
                if (i == 0 && ((VehicleStats)vehicle.getStats()).rootHitboxNoCollide) continue;
                this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.literal((String)("H: " + (int)health + "/" + (int)max_health)).m_6270_(healthStyle), (float)(startX + this.maxHitboxNameWidth), (float)(startY + i * 10), 0xFFFFFF);
                this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.literal((String)("A: " + (int)armor + "/" + (int)max_armor)).m_6270_(armorStyle), (float)(startX + this.maxHitboxNameWidth + 70), (float)(startY + i * 10), 0xFFFFFF);
            }
            poseStack.m_85849_();
        }
        int xOrigin = this.guiX + this.left_padding + 2;
        int yOrigin = this.guiY + this.top_padding + 130;
        RenderSystem.m_157456_((int)0, (ResourceLocation)FUEL_GAUGE);
        VehicleHealthScreen.m_93133_((PoseStack)poseStack, (int)xOrigin, (int)yOrigin, (float)0.0f, (float)0.0f, (int)60, (int)40, (int)60, (int)40);
        float max = vehicle.getMaxFuel();
        float fuelPercent = 0.0f;
        if (max != 0.0f) {
            fuelPercent = vehicle.getCurrentFuel() / max;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)FUEL_GAUGE_ARROW);
        poseStack.m_85836_();
        poseStack.m_85837_((double)xOrigin + 30.0, (double)(yOrigin + 24), 0.0);
        poseStack.m_85845_(Vec3f.ZP.rotationDegrees(160.0f * fuelPercent + 10.0f).convert());
        VehicleHealthScreen.m_93133_((PoseStack)poseStack, (int)-19, (int)-3, (float)0.0f, (float)0.0f, (int)24, (int)7, (int)24, (int)7);
        poseStack.m_85849_();
        double thrustToWeight = (double)vehicle.getAfterburnerMaxPushThrust() / ((double)vehicle.getTotalMass() * vehicle.getAccGravity());
        this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.translatable((String)"ui.dscombat.thrust_to_weight_ratio"), (float)(this.guiX + this.left_padding + 100), (float)(this.guiY + this.top_padding + 150), 170);
        this.f_96541_.f_91062_.m_92889_(poseStack, (Component)UtilMCText.literal((String)UtilPrint.printDec(thrustToWeight, 4)), (float)(this.guiX + this.left_padding + 100), (float)(this.guiY + this.top_padding + 160), VehicleHealthScreen.getThrustToWeightColor(thrustToWeight));
    }

    public static int getHealthColor(float health, float max) {
        return VehicleStatsOverlay.getHealthColor(health, max);
    }

    public static int getThrustToWeightColor(double thrustToWeight) {
        if (thrustToWeight > 1.0) {
            return VehicleStatsOverlay.GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        return VehicleStatsOverlay.RED.getRGB();
    }
}

