/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VehicleReloadScreen
extends VehicleSubScreen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_reload_screen.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private static final Style style = Style.f_131099_.m_178520_(34816);

    protected VehicleReloadScreen() {
        super("screen.dscombat.vehicle_reload_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    @Override
    protected void m_7856_() {
        int xStart;
        this.COLUMNS = 3;
        this.vertical_widget_shift = 10;
        super.m_7856_();
        this.positionWidgetGrid((AbstractWidget)new Button(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.reload_all"), onPress -> this.onReloadAllButton()), this.ROWS, this.COLUMNS, 1, 2);
        this.positionWidgetGrid((AbstractWidget)new Button(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.unload_all"), onPress -> this.onUnloadAllButton()), this.ROWS, this.COLUMNS, 2, 2);
        this.vertical_widget_shift = 34;
        float scale = 0.6666667f;
        int textHeight = (int)(20.0f * scale);
        int x = xStart = this.guiX + this.left_padding;
        int y = this.guiY + this.top_padding + this.vertical_widget_shift;
        int width = (this.image_width - this.left_padding - this.right_padding) / 3;
        List<PartSlot> slots = this.getVehicle().partsManager.getReloadableParts();
        int halfWidth = width / 2;
        for (int i = 0; i < slots.size(); ++i) {
            PartSlot slot = slots.get(i);
            ReloadablePartInstance part = (ReloadablePartInstance)((Object)slot.getPartData());
            if (part == null) continue;
            Button reload = new Button(0, 0, halfWidth, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.reload"), onPress -> this.onReloadButton(slot.getSlotId()));
            reload.f_93620_ = x;
            reload.f_93621_ = y + textHeight;
            this.m_142416_((GuiEventListener)reload);
            Button unload = new Button(0, 0, halfWidth, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.unload"), onPress -> this.onUnloadButton(slot.getSlotId()));
            unload.f_93620_ = x + halfWidth;
            unload.f_93621_ = y + textHeight;
            this.m_142416_((GuiEventListener)unload);
            if (i % 3 == 2) {
                y += textHeight + 20;
                x = xStart;
                continue;
            }
            x += width;
        }
    }

    @Override
    public void m_7333_(@NotNull PoseStack poseStack) {
        int xStart;
        super.m_7333_(poseStack);
        poseStack.m_85836_();
        float scale = 0.6666667f;
        poseStack.m_85841_(scale, scale, 1.0f);
        int x = xStart = (int)((float)(this.guiX + this.left_padding) / scale);
        int y = (int)((float)(this.guiY + this.top_padding + this.vertical_widget_shift) / scale);
        int width = (int)((float)(this.image_width - this.left_padding - this.right_padding) / 3.0f / scale);
        List<PartSlot> slots = this.getVehicle().partsManager.getReloadableParts();
        for (int i = 0; i < slots.size(); ++i) {
            ReloadablePartInstance part = (ReloadablePartInstance)((Object)slots.get(i).getPartData());
            if (part == null) continue;
            this.f_96541_.f_91062_.m_92889_(poseStack, (Component)part.getItemName().m_6270_(style), (float)x, (float)y, 0xFFFFFF);
            MutableComponent ammo = UtilMCText.translatable((String)"info.dscombat.ammo").m_130946_(": " + (int)part.getCurrentAmmo() + "/" + (int)part.getMaxAmmo());
            this.f_96541_.f_91062_.m_92889_(poseStack, (Component)ammo.m_6270_(style), (float)x, (float)(y + 10), 0xFFFFFF);
            if (i % 3 == 2) {
                y += 50;
                x = xStart;
                continue;
            }
            x += width;
        }
        poseStack.m_85849_();
    }

    private void onReloadAllButton() {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(false));
    }

    private void onUnloadAllButton() {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(true));
    }

    private void onReloadButton(String slotId) {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(slotId, false));
    }

    private void onUnloadButton(String slotId) {
        VehicleReloadScreen.sendSyncAction(new VehicleSyncAction.LoadPartAction(slotId, true));
    }
}

