/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.event;

import com.mojang.brigadier.CommandDispatcher;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.command.DSCAdminCommands;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.command.DSCParticleDebugCommand;
import com.onewhohears.dscombat.command.DebugHitboxPosCommand;
import com.onewhohears.dscombat.command.DebugSlotPosCommand;
import com.onewhohears.dscombat.command.MissileCommand;
import com.onewhohears.dscombat.command.VehicleCommand;
import com.onewhohears.dscombat.command.WindTunnelCommand;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.data.graph.StatGraphs;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.radar.RadarPresets;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.villager.DSCVillagerTrades;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.RadarTargetTypes;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitboxes;
import com.onewhohears.onewholibs.common.event.OWLEvents;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.config.ModConfig;

public class CommonEventHandlers {
    private static final Set<Integer> explodeRepeatCheck = new HashSet<Integer>();

    public static void init() {
        OWLEvents.GET_JSON_PRESET_LISTENERS.register(CommonEventHandlers::registerPresetListeners);
        LifecycleEvent.SERVER_STOPPING.register(CommonEventHandlers::serverStoppingEvent);
        LifecycleEvent.SETUP.register(CommonEventHandlers::onSetup);
        TickEvent.SERVER_PRE.register(CommonEventHandlers::onServerTickPre);
        TickEvent.PLAYER_POST.register(CommonEventHandlers::onPlayerTick);
        ExplosionEvent.DETONATE.register(CommonEventHandlers::onExplosionDetonate);
        CommandRegistrationEvent.EVENT.register(CommonEventHandlers::registerCommands);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        new MissileCommand(dispatcher);
        new VehicleCommand(dispatcher);
        new DSCParticleDebugCommand(dispatcher);
        new DebugSlotPosCommand(dispatcher);
        new DebugHitboxPosCommand(dispatcher);
        new DSCAdminCommands(dispatcher);
        new WindTunnelCommand(dispatcher);
    }

    public static void onSetup() {
        PhysicsComponentData.register();
        VehicleSyncAction.register();
        PacketHandler.register();
        DSCGameRules.registerAll();
        DependencySafety.fmlCommonSetup();
        DSCVillagerTrades.register();
    }

    public static float onLivingHurt(LivingEntity livingEntity, DamageSource damageSource, float amount) {
        Entity entity;
        if (damageSource.m_19387_()) {
            return amount;
        }
        if (!livingEntity.m_20159_() || !((entity = livingEntity.m_20201_()) instanceof EntityVehicle)) {
            return amount;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        return plane.calcDamageToRider(damageSource, amount);
    }

    public static void onExplosionDetonate(Level level, Explosion explosion, List<Entity> affectedEntities) {
        explodeRepeatCheck.clear();
        for (Entity e : affectedEntities) {
            if (!e.m_6128_() || explodeRepeatCheck.contains(e.m_19879_()) || !(e instanceof CustomExplosion)) continue;
            CustomExplosion entity = (CustomExplosion)e;
            entity.customExplosionHandler(explosion);
            explodeRepeatCheck.add(e.m_19879_());
        }
    }

    public static void onPlayerTick(Player player) {
        if (player.m_21255_() && UtilEntity.getLevel((Entity)player).m_46469_().m_46207_(DSCGameRules.DISABLE_ELYTRA_FLYING)) {
            player.m_36321_();
        }
    }

    public static void onServerTickPre(MinecraftServer server) {
        NonTickingMissileManager.serverTick(server);
        TrackableEntitiesManager.serverTick(server);
    }

    public static void registerPresetListeners(List<JsonPresetReloadListener<?>> listeners) {
        listeners.add(StatGraphs.get());
        listeners.add(VehiclePresets.get());
        listeners.add(WeaponPresets.get());
        listeners.add(RadarPresets.get());
        listeners.add(PartPresets.get());
    }

    public static void serverStoppingEvent(MinecraftServer server) {
        RotableHitboxes.onServerStop();
    }

    public static void onReadConfig(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.COMMON) {
            RadarTargetTypes.get().readConfig();
        }
    }
}

