/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network;

import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleSyncAction;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.item.ItemParachute;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleSyncAction {
    public static final BiPredicate<Player, EntityVehicle> PILOT_CHECK = (player, vehicle) -> {
        if (!vehicle.isPilotOrCopilot((Entity)player)) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.not_a_pilot"), true);
            return false;
        }
        return true;
    };
    public static final BiPredicate<Player, EntityVehicle> OWNER_CHECK = (player, vehicle) -> {
        if (!vehicle.isOwner((Entity)player)) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.not_owner"), true);
            return false;
        }
        return true;
    };
    public static final BiPredicate<Player, EntityVehicle> PERMISSION_CHECK = (player, vehicle) -> {
        if (!vehicle.hasPermission((Entity)player)) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.no_perm_vehicle"), true);
            return false;
        }
        return true;
    };
    private static final IntObjectMap<VehicleSyncAction> sync_action_map = new IntObjectHashMap();
    private final int id;

    public static void register() {
        VehicleSyncAction.addVehicleSyncAction(new LandingGearAction(false));
        VehicleSyncAction.addVehicleSyncAction(new OpenStorageAction(0));
        VehicleSyncAction.addVehicleSyncAction(new OpenPartsAction());
        VehicleSyncAction.addVehicleSyncAction(new SetRadarModeAction(RadarStats.RadarMode.ALL));
        VehicleSyncAction.addVehicleSyncAction(new PingSelectAction(null));
        VehicleSyncAction.addVehicleSyncAction(new ShootAction(-1, null, null));
        VehicleSyncAction.addVehicleSyncAction(new ToItemAction());
        VehicleSyncAction.addVehicleSyncAction(new DismountAction());
        VehicleSyncAction.addVehicleSyncAction(new SwitchSeatAction());
        VehicleSyncAction.addVehicleSyncAction(new LoadPartAction("", false));
        VehicleSyncAction.addVehicleSyncAction(new JetesinAction(""));
        VehicleSyncAction.addVehicleSyncAction(new SetPermModeAction(EntityVehicle.PermMode.PUBLIC));
        VehicleSyncAction.addVehicleSyncAction(new SetCustomNameAction((Component)Component.m_237119_()));
    }

    public static void sendSyncAction(VehicleSyncAction action) {
        new ToServerVehicleSyncAction(action).sendToServer();
    }

    @Nullable
    public static VehicleSyncAction getAction(int id) {
        return (VehicleSyncAction)sync_action_map.get(id);
    }

    public static void addVehicleSyncAction(VehicleSyncAction action) {
        sync_action_map.put(action.id, (Object)action);
    }

    protected VehicleSyncAction(int id) {
        this.id = id;
    }

    protected abstract BiPredicate<Player, EntityVehicle> getPermissionCheck();

    protected abstract BiConsumer<ServerPlayer, EntityVehicle> getServerAction();

    protected abstract Consumer<FriendlyByteBuf> getWriteData();

    protected abstract Consumer<FriendlyByteBuf> getReadData();

    public int getId() {
        return this.id;
    }

    public void writeData(FriendlyByteBuf buffer) {
        this.getWriteData().accept(buffer);
    }

    public void readData(FriendlyByteBuf buffer) {
        this.getReadData().accept(buffer);
    }

    public boolean hasPermission(Player player, EntityVehicle vehicle) {
        return this.getPermissionCheck().test(player, vehicle);
    }

    public void runServerAction(ServerPlayer player, EntityVehicle vehicle) {
        this.getServerAction().accept(player, vehicle);
    }

    public static class LandingGearAction
    extends VehicleSyncAction {
        private boolean active;

        public LandingGearAction(boolean active) {
            super(0);
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return PILOT_CHECK;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setLandingGear(this.isActive());
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.writeBoolean(this.isActive());
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.active = buffer.readBoolean();
            };
        }
    }

    public static class OpenStorageAction
    extends VehicleSyncAction {
        private int index;

        public OpenStorageAction(int index) {
            super(1);
            this.index = index;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                if (!vehicle.canOpenPartsMenu()) {
                    player.m_5661_((Component)UtilMCText.translatable((String)vehicle.getOpenMenuError()), true);
                    return false;
                }
                if (!vehicle.partsManager.hasStorageBoxes()) {
                    player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.no_storage_boxes"), true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.openStorage((ServerPlayer)player, this.index);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.writeInt(this.index);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.index = buffer.readInt();
            };
        }
    }

    public static class OpenPartsAction
    extends VehicleSyncAction {
        public OpenPartsAction() {
            super(2);
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                if (!vehicle.canOpenPartsMenu()) {
                    player.m_5661_((Component)UtilMCText.translatable((String)vehicle.getOpenMenuError()), true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.openPartsMenu((ServerPlayer)player);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {};
        }
    }

    public static class SetRadarModeAction
    extends VehicleSyncAction {
        private RadarStats.RadarMode mode;

        public SetRadarModeAction(RadarStats.RadarMode mode) {
            super(3);
            this.mode = mode;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setRadarMode(this.mode);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.m_130068_((Enum)this.mode);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.mode = (RadarStats.RadarMode)buffer.m_130066_(RadarStats.RadarMode.class);
            };
        }
    }

    public static class PingSelectAction
    extends VehicleSyncAction {
        private RadarStats.RadarPing ping;

        public PingSelectAction(RadarStats.RadarPing ping) {
            super(4);
            this.ping = ping;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.radarSystem.selectTarget(this.ping);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> this.ping.write((FriendlyByteBuf)buffer);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.ping = new RadarStats.RadarPing((FriendlyByteBuf)buffer);
            };
        }
    }

    public static class ShootAction
    extends VehicleSyncAction {
        private int selectedWeaponIndex;
        @Nullable
        private RadarStats.RadarPing ping;
        @Nullable
        private Vec3 targetPos;

        public ShootAction(int selectedWeaponIndex, @Nullable RadarStats.RadarPing ping, @Nullable Vec3 targetPos) {
            super(5);
            this.selectedWeaponIndex = selectedWeaponIndex;
            this.ping = ping;
            this.targetPos = targetPos;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                Entity patt0$temp = player.m_20202_();
                if (!(patt0$temp instanceof EntityRidablePart)) {
                    return;
                }
                EntityRidablePart seat = (EntityRidablePart)patt0$temp;
                if (this.ping != null) {
                    vehicle.radarSystem.selectTarget(this.ping);
                }
                if (this.targetPos != null) {
                    vehicle.weaponSystem.setTargetPos(this.targetPos);
                }
                if (seat.isTurret()) {
                    ((EntityTurret)seat).shoot((Entity)player);
                    return;
                }
                if (this.selectedWeaponIndex == -1) {
                    return;
                }
                if (!seat.canPassengerShootParentWeapon()) {
                    return;
                }
                vehicle.weaponSystem.setSelected(this.selectedWeaponIndex);
                vehicle.weaponSystem.shootSelected((Entity)player);
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> {
                buffer.writeInt(this.selectedWeaponIndex);
                if (this.ping != null) {
                    buffer.writeBoolean(true);
                    this.ping.write((FriendlyByteBuf)buffer);
                } else {
                    buffer.writeBoolean(false);
                }
                if (this.targetPos != null) {
                    buffer.writeBoolean(true);
                    DataSerializers.VEC3.m_6856_(buffer, (Object)this.targetPos);
                } else {
                    buffer.writeBoolean(false);
                }
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.selectedWeaponIndex = buffer.readInt();
                this.ping = buffer.readBoolean() ? new RadarStats.RadarPing((FriendlyByteBuf)buffer) : null;
                this.targetPos = buffer.readBoolean() ? (Vec3)DataSerializers.VEC3.m_6709_(buffer) : null;
            };
        }
    }

    public static class ToItemAction
    extends VehicleSyncAction {
        public ToItemAction() {
            super(6);
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> {
                Component reason = vehicle.getCantBecomeItemReason((Player)player);
                if (reason != null) {
                    player.m_5661_(reason, true);
                    return false;
                }
                return true;
            };
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                ItemStack item = vehicle.getItem();
                if (player.m_150109_().m_36062_() != -1 && player.m_36356_(item)) {
                    vehicle.m_146870_();
                    return;
                }
                vehicle.becomeItem(player.m_20182_());
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {};
        }
    }

    public static class DismountAction
    extends VehicleSyncAction {
        private boolean eject = false;

        public DismountAction() {
            super(7);
        }

        public DismountAction(boolean eject) {
            this();
            this.eject = eject;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                EntityRidablePart seat;
                Entity patt0$temp;
                if (this.eject && (patt0$temp = player.m_20202_()) instanceof EntityRidablePart && (seat = (EntityRidablePart)patt0$temp).canEject()) {
                    Vec3 dir;
                    seat.useEject();
                    player.m_8127_();
                    double EJECT_PUSH = 4.0;
                    double EJECT_MOVE = 1.0;
                    if (vehicle != null) {
                        dir = UtilAngles.getYawAxis((QuaternionF)vehicle.getQ());
                        player.m_20256_(vehicle.m_20184_().m_82549_(dir.m_82490_(EJECT_MOVE)));
                    } else {
                        dir = new Vec3(0.0, 1.0, 0.0);
                    }
                    player.m_146884_(player.m_20182_().m_82549_(dir.m_82490_(EJECT_PUSH)));
                    ServerLevel level = (ServerLevel)UtilEntity.getLevel((Entity)player);
                    ItemParachute.createParachute(level, (Player)player, null);
                    level.m_5594_(null, player.m_20183_(), ModSounds.EJECT, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_8127_();
                }
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.writeBoolean(this.eject);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.eject = buffer.readBoolean();
            };
        }
    }

    public static class SwitchSeatAction
    extends VehicleSyncAction {
        public SwitchSeatAction() {
            super(8);
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> true;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (!vehicle.switchSeat((Entity)player)) {
                    player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.no_open_seats"), true);
                }
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> {};
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {};
        }
    }

    public static class LoadPartAction
    extends VehicleSyncAction {
        private String slotId = "";
        private boolean unload = false;
        private boolean all = false;

        public LoadPartAction(String slotId, boolean unload) {
            super(9);
            this.slotId = slotId;
            this.unload = unload;
        }

        public LoadPartAction(boolean unload) {
            super(9);
            this.unload = unload;
            this.all = true;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return (player, vehicle) -> vehicle.canReload((Player)player);
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (this.all) {
                    for (PartSlot slot : vehicle.partsManager.getReloadableParts()) {
                        this.handleSlot((ServerPlayer)player, (ReloadablePartInstance)((Object)slot.getPartData()));
                    }
                } else {
                    this.handleSlot((ServerPlayer)player, vehicle.partsManager.getReloadablePart(this.slotId));
                }
            };
        }

        private void handleSlot(ServerPlayer player, @Nullable ReloadablePartInstance part) {
            if (part == null) {
                return;
            }
            if (this.unload && (!this.all || part.canUnload())) {
                part.unloadPartToInventory(player);
            } else {
                part.loadPartFromInventory(player);
            }
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> {
                buffer.m_130070_(this.slotId);
                buffer.writeBoolean(this.unload);
                buffer.writeBoolean(this.all);
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.slotId = buffer.m_130277_();
                this.unload = buffer.readBoolean();
                this.all = buffer.readBoolean();
            };
        }
    }

    public static class JetesinAction
    extends VehicleSyncAction {
        private String slotId = "";

        public JetesinAction(String slotId) {
            super(10);
            this.slotId = slotId;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return PILOT_CHECK;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.jetesinPart(this.slotId);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.m_130070_(this.slotId);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.slotId = buffer.m_130277_();
            };
        }
    }

    public static class SetPermModeAction
    extends VehicleSyncAction {
        private EntityVehicle.PermMode mode;

        public SetPermModeAction(EntityVehicle.PermMode mode) {
            super(11);
            this.mode = mode;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return OWNER_CHECK;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> vehicle.setPermMode(this.mode);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.m_130068_((Enum)this.mode);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.mode = (EntityVehicle.PermMode)buffer.m_130066_(EntityVehicle.PermMode.class);
            };
        }
    }

    public static class SetCustomNameAction
    extends VehicleSyncAction {
        private Component name;

        public SetCustomNameAction(Component name) {
            super(12);
            this.name = name;
        }

        @Override
        protected BiPredicate<Player, EntityVehicle> getPermissionCheck() {
            return PERMISSION_CHECK;
        }

        @Override
        protected BiConsumer<ServerPlayer, EntityVehicle> getServerAction() {
            return (player, vehicle) -> {
                if (this.name.getString().isEmpty()) {
                    vehicle.m_6593_(null);
                } else {
                    vehicle.m_6593_(this.name);
                }
            };
        }

        @Override
        protected Consumer<FriendlyByteBuf> getWriteData() {
            return buffer -> buffer.m_130083_(this.name);
        }

        @Override
        protected Consumer<FriendlyByteBuf> getReadData() {
            return buffer -> {
                this.name = buffer.m_130238_();
            };
        }
    }
}

