/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class ToClientOnShoot
extends BaseS2CMessage {
    public final int vehicleId;
    public final int shooterId;
    public final UtilClientPacket.ShootType type;

    public static void onShootWeaponRack(EntityWeaponRack rack, Entity shooter) {
        if (rack.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(rack.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.WEAPON_RACK), (Entity)rack);
    }

    public static void onShootTurret(EntityTurret turret, Entity shooter) {
        if (turret.isClientSide()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(turret.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.TURRET), (Entity)turret);
    }

    public static void onShootFlareRack(EntityVehicle vehicle, Entity shooter) {
        if (vehicle.getWorld().m_5776_()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(vehicle.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.FLARE), (Entity)vehicle);
    }

    public static void onShootChaffRack(EntityVehicle vehicle, Entity shooter) {
        if (vehicle.getWorld().m_5776_()) {
            return;
        }
        PacketHandler.sendToTrackers(new ToClientOnShoot(vehicle.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.CHAFF), (Entity)vehicle);
    }

    private ToClientOnShoot(int vehicleId, int shooterId, UtilClientPacket.ShootType type) {
        this.vehicleId = vehicleId;
        this.shooterId = shooterId;
        this.type = type;
    }

    public ToClientOnShoot(FriendlyByteBuf buffer) {
        this.vehicleId = buffer.readInt();
        this.shooterId = buffer.readInt();
        this.type = (UtilClientPacket.ShootType)buffer.m_130066_(UtilClientPacket.ShootType.class);
    }

    public MessageType getType() {
        return PacketHandler.S2C_ON_SHOOT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.vehicleId);
        buffer.writeInt(this.shooterId);
        buffer.m_130068_((Enum)this.type);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> UtilClientPacket.onShoot(this.vehicleId, this.shooterId, this.type));
    }
}

