/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.stats.BuffStats;
import com.onewhohears.dscombat.data.parts.stats.EngineStats;
import com.onewhohears.dscombat.data.parts.stats.TurretStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class PartBuilder
extends IngredientStackBuilder<PartBuilder> {
    private String ingredientListName = "ingredients";

    public static PartBuilder create(ResourceLocation item, PartType type) {
        PartBuilder builder = PartBuilder.create(item.m_135827_(), item.m_135815_(), item, type);
        builder.setDisplayName("item." + item.m_135827_() + "." + item.m_135815_());
        return builder;
    }

    public static PartBuilder create(String namespace, String name, ResourceLocation item, PartType type) {
        PartBuilder builder = new PartBuilder(namespace, name, type);
        builder.setItem(item);
        builder.setDisplayName("item." + namespace + "." + name);
        return builder;
    }

    public PartBuilder addRepairCost(String itemId, int num) {
        this.ingredientListName = "repair_cost";
        return (PartBuilder)super.addIngredient(itemId, num);
    }

    public PartBuilder addIngredient(String itemId, int num) {
        this.ingredientListName = "ingredients";
        return (PartBuilder)super.addIngredient(itemId, num);
    }

    public String getIngredientListName() {
        return this.ingredientListName;
    }

    protected PartBuilder(String namespace, String name, PartType type) {
        super(namespace, name, (JsonPresetType)type);
    }

    public PartBuilder setWeight(float weight) {
        return (PartBuilder)this.setFloat("weight", weight);
    }

    protected PartBuilder setItem(ResourceLocation item) {
        return (PartBuilder)this.setString("item", item.toString());
    }

    public PartBuilder setCompatibleSlotType(SlotType type) {
        return (PartBuilder)this.setString("slotType", type.getSlotTypeName());
    }

    public PartBuilder setExternalEntityType(ResourceLocation externalEntity) {
        return (PartBuilder)this.setString("externalEntity", externalEntity.toString());
    }

    public PartBuilder setEntityHitboxSize(float width, float height) {
        this.setFloat("hitbox_width", width);
        return (PartBuilder)this.setFloat("hitbox_height", height);
    }

    public PartBuilder setBuffStats(BuffStats.BuffType buff) {
        return (PartBuilder)this.setEnum("buffType", buff);
    }

    public PartBuilder setEngineStats(EngineStats.EngineType engineType, float thrust, float heat, float fuelRate) {
        this.setFloat("thrust", thrust);
        this.setFloat("heat", heat);
        this.setFloat("fuelRate", fuelRate);
        return (PartBuilder)this.setEnum("engineType", engineType);
    }

    public PartBuilder setFlareDispenserStats(int max, int age, float heat) {
        this.setInt("max", max);
        this.setInt("age", age);
        return (PartBuilder)this.setFloat("heat", heat);
    }

    public PartBuilder setFuelTankStats(float max) {
        return (PartBuilder)this.setFloat("max", max);
    }

    public PartBuilder setRadarStats(String radar) {
        return (PartBuilder)this.setString("radar", radar);
    }

    public PartBuilder setStorageStats(int size) {
        return (PartBuilder)this.setInt("size", size);
    }

    public PartBuilder setTurretStats(int maxAmmo, float maxHealth, Vec3 passengerOffset, double weaponOffset, TurretStats.RotBounds rotBounds, EntityTurret.ShootType shootType, float width, float height) {
        this.setFloat("maxHealth", maxHealth);
        this.setEntityHitboxSize(width, height);
        this.setExternalEntityType(ModEntities.TURRET.getId());
        UtilParse.writeVec3((JsonObject)this.getData(), (String)"passenger_offset", (Vec3)passengerOffset);
        this.setFloat("weaponOffset", (float)weaponOffset);
        rotBounds.writeToJson(this.getData());
        UtilParse.writeEnum((JsonObject)this.getData(), (String)"shootType", (Enum)shootType);
        return (PartBuilder)this.setInt("maxAmmo", maxAmmo);
    }

    public PartBuilder setTurretStats(int maxAmmo, float maxHealth, Vec3 passengerOffset, double weaponOffset, TurretStats.RotBounds rotBounds, float width, float height) {
        return this.setTurretStats(maxAmmo, maxHealth, passengerOffset, weaponOffset, rotBounds, EntityTurret.ShootType.NORMAL, width, height);
    }

    public PartBuilder setWeaponStats(int max) {
        return (PartBuilder)this.setInt("max", max);
    }

    public PartBuilder setExternalWeaponStats(int max, float changeLaunchPitch) {
        this.setWeaponStats(max);
        this.setEntityHitboxSize(0.1f, 0.1f);
        this.setExternalEntityType(ModEntities.EXTERNAL_WEAPON_PART.getId());
        return (PartBuilder)this.setFloat("changeLaunchPitch", changeLaunchPitch);
    }
}

